@extends('admin.masterBlade')

@section('title')
    Blog List
@endsection

@section('content')

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">
                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Blog List
                                <a href="{{route('blog.list')}}">
                                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>

                        <form action="{{route('update.blog')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
                            @csrf
                            <div class="card-body">

                                <div class="form-group">
                                    <div class="row ">
                                        <div class="col-md-6 form-group">
                                            <label>Title <span class="text-danger">*</span></label>
                                            <input type="text" name="title" value="{{$blog->title}}" class="form-control" required >
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>Image Alt Name</label>
                                            <input type="text" name="image_alt_name" value="{{$blog->image_alt_name}}" class="form-control" placeholder="Image alt attributes name">
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <label>Image <span class="text-danger">*</span></label>
                                            <input type="file" name="image" id="image" class="form-control">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <img id="showImage" src="{{(!empty($blog->image)) ? url('upload/blog/'.$blog->image):url('upload/NoImage.png')}}"
                                                style="width: 150px; height: 100px; border: 1px solid #000000;">
                                        </div>
                                    </div>
                                    <div class=" form-group">
                                        <label>Blog Details <span class="text-danger">*</span></label>
                                        <textarea id="summernote" name="description" required="" >{!! $blog->description !!}</textarea>
                                    </div>

                                    <input type="hidden" name="id" value="{{$blog->id}}">
                                </div>
                                <div class="card-footer justify-content-between text-right">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#image').change(function (e) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>

@endsection
