@extends('admin.masterBlade')

@section('title')
General Expense Edit
@endsection
@section('content')

<section class="content" style="padding: 15px;">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-10">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header">
                        <h5 class="m-0 text-white text-center">General Expense Edit
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.box-header -->

                    <div class="card-body">
                        <form method="post" action="{{url('expense-update-'.$findData->id)}}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Expense Type<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="expense_type" required="" class="form-control select2bs4">
                                                        <option value="" selected="" disabled="">Select location
                                                        </option>
                                                        @foreach ($data as $item)
                                                            <option value="{{$item->id}}" {{($item->id==$findData->expense_type)?'selected':''}}>{{$item->expense_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Description: </h5>
                                                <div class="controls">
                                                    <textarea type="text" name="discription"
                                                        class="form-control">{{$findData->discription}}</textarea>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Transection Date</h5>
                                                <div class="controls">
                                                    <input type="date" name="date" class="form-control" value="{{$findData->date}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Amount</h5>
                                                <div class="controls">
                                                    <input type="number" name="amount" class="form-control" value="{{$findData->amount}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

@endsection
