
@extends('admin.masterBlade')

@section('title')
Expense Type List
@endsection

@section('content')
@php
    $check = 0;
@endphp
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">General Expense List
                            <a href="{{url('general-expense')}}">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">

                        <div class="row">
                            <div class="col">
                                <form id="updateGexForm" method="post" action="{{url('update-general-expense-'.$data->id)}}" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="findGenExpid" id="id">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="row" >
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <h5> General Expense Edit<span class="text-danger">*</span></h5>
                                                        <div class="controls">
                                                            <select name="expense_type_id" id="expense_type_id" required="" class="form-control">
                                                                <option value="" selected="" disabled="">Select Expense
                                                                </option>
                                                                @foreach ($expType as $item)
                                                                   <option value="{{$item->id}}" {{($item->id == $data->expense_type_id) ? "selected":""}}>{{$item->name}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>
                                                    </div>
                                                </div> <!-- End Col md 6 -->
                                                <div class="col-md-6">
                                                    <h5>Transaction ID</h5>
                                                    <div class="form-group">
                                                        <input type="text" class="form-control" name="transactionID" value="{{ $data->transactionID }}">
                                                        </div>
                                                </div> <!-- End Col md 6 -->
                                            </div>
                                            <div class="row" >
                                                <div class="col-md-6">
                                                    <h5>Date <span class="text-danger">*</span></h5>
                                                    <div class="form-group">
                                                        <input type="date" class="form-control" name="date" value="{{$data->date}}" id="date" required="">
                                                     </div>
                                                </div> <!-- End Col md 4 -->

                                                <div class="col-md-6">
                                                    <h5>Amount <span class="text-danger">*</span></h5>
                                                    <div class="form-group">
                                                       <input type="number" class="form-control" name="amount" min="0" step="0.01" value="{{$data->amount}}" placeholder="Annount" id="amount" required="">
                                                    </div>
                                                </div> <!-- End Col md 4 -->
                                            </div>

                                            <div class="row" >
                                                <div class="col-md-12">
                                                    <h5>Reason <span class="text-danger">*</span></h5>
                                                    <div class="form-group">
                                                       <textarea type="text" name="reason" class="form-control"  required="" placeholder="Write Reason About General Expense">{{$data->reason}}</textarea>
                                                     </div>
                                                </div> <!-- End Col md 4 -->
                                            </div>

                                            <div class="row" style="margin-top: 20px">
                                                <!-- 7TH Row -->
                                                <div class="col-md-5">
                                                    <div class="text-xs-right">
                                                        <input type="submit" class="btn btn-rounded btn-primary mb-5" id="updateGexBtn" value="Submit">
                                                    </div>
                                                </div>

                                            </div> <!-- End 7TH Row -->
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- /.col -->
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>


@endsection

