@extends('admin.masterBlade')

@section('title')
Expense Type List
@endsection

@section('content')
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-10 col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Expense Type List
                            <a href="#" title="" data-toggle="modal" data-target="#modal-xl">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <a href="{{url('view-system-config')}}">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Expense Name</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$eT)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$eT->name }}</td>
                                    <td>{{$eT->created_date}}</td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                <a class="dropdown-item" href="" onclick="getVelue({{$eT->id}})"  data-toggle="modal" data-target="#modal-edit"><span
                                                        class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                <a class="dropdown-item" id="delete" href="{{url('delete-service-'.$eT->id)}}"><span
                                                        class="fa fa-trash" style="padding-right:10px;"></span> Delete</a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="modal-xl">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Expense Type</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('store-expense-type')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Expense Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="name" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="modal-edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Expense Type</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('update-expense-type')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" id="findExpid" name="id">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Expense Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="name" id="expense_name" value="" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<script>
    function getVelue(r)
    {
       console.log(r);
       $("#findExpid").val(r);
       var id = r;

       if (id != '') {
            $.ajax({
                url: "findExpense",
                method: "GET",
                data: {
                    id: id
                },
                dataType: "JSON",
                success: function (data)
                {
                    console.log(data.name);
                    $("#expense_name").val(data.name);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>


@endsection
