@extends('admin.masterBlade')

@section('title')
Employee Profile
@endsection

@section('content')


<section class="content" style="padding-top: 10px;">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-9">
                <div class="card card-primary card-outline card-tabs">
                    <div class="card-header p-0 pt-1 border-bottom-0">
                        <ul class="nav nav-tabs">
                            <li class="nav-item"><a class="nav-link active" href="#activity" data-toggle="tab">Profile</a></li>
                            <li class="nav-item"><a class="nav-link" href="#settings" data-toggle="tab">Accounts</a>
                            </li>
                        
                        </ul>
                    </div><!-- /.card-header -->

                   
                    <div class="card-body">
                        <div class="tab-content">
                             <!------------------------Profile------------------------------>
                            <div class="active tab-pane" id="activity">

                                <div class="row">
                                    <div class="col-md-4" >
                    
                                        <!-- Profile Image -->
                                        <div class="card card-primary">
                                            <div class="card-body box-profile">
                                                <div class="text-center">
                                                    <img class="profile-user-img img-fluid img-circle" src="{{(!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')}}" alt="User Avatar">
                                                   
                                                </div>
                    
                                                <h3 class="profile-username text-center"><b>{{$data->name}}</b></h3>
                    
                                                <p class="text-muted text-center">@if($data->role==1)Super Admin @elseif($data->role==2) Admin @endif</p>
                    
                                                <ul class="list-group list-group-unbordered mb-3">
                                                    <li class="list-group-item">
                                                        <b>Email</b> <a class="float-right">{{$data->email}}</a>
                                                    </li>
                                                    <li class="list-group-item">
                                                        <b>Phone</b> <a class="float-right">{{$data->phone}}</a>
                                                    </li>
                                                    <li class="list-group-item">
                                                        <b>Gender</b> <a class="float-right">{{$data->gender}}</a>
                                                    </li>
                                                </ul>

                                                <strong><i class="fas fa-map-marker-alt mr-1"></i> Location</strong>
                    
                                                <p class="text-muted">{{$data->address}}</p>
                    
                                                <hr>
                    
                                                <strong><i class="fas fa-calendar-day"></i>  Date Of Birth</strong>
                    
                                                <p class="text-muted">{{$data->dob}}</p>
                    
                                                <hr>
                    
                                                <strong><i class="fas fa-calendar-day"></i> Joining Date</strong>
                    
                                                <p class="text-muted">{{$data->joining_date}}</p>
                    
                                                <hr>
                                                    <a href="{{url('edit-profile-'.$data->id)}}" class="btn btn-primary btn-block"><b>Edit Profile</b></a>
                    
                                                
                                            </div>
                                            <!-- /.card-body -->
                                        </div>
                                        <!-- /.card -->
                
                                    </div>
                                    <!-- /.col -->

                                    <div class="col-md-8" >
                    
                                        <!-- Profile Image -->
                                        <div class="card card-primary">
                                            <div class="card-body box-profile">
                                               
                                                
                                            </div>
                                            <!-- /.card-body -->
                                        </div>
                                        <!-- /.card -->
                
                                    </div>
                                    <!-- /.col -->
                                   
                                </div>
                                <!-- /.row -->
                              

                            </div>
                            <!-- /.tab-pane -->
                            

                             <!------------------------Accounts------------------------------>
                            <div class="tab-pane" id="settings">
                               
                            </div>
                            <!-- /.tab-pane -->
                        </div>
                        <!-- /.tab-content -->
                    </div><!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>

@endsection
