@extends('admin.masterBlade')

@section('title')
Teacher Profile
@endsection

@section('content')

<section class="content" style="padding-top: 10px;">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-3">

                <!-- Profile Image -->
                <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                        <div class="text-center">
                            <img class="profile-user-img img-fluid img-circle"
                                src="{{(!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')}}"
                                alt="User Avatar">

                        </div>

                        <h6 class="profile-username text-center"><b>{{$data->name}}</b> <a href="" data-toggle="modal"
                                data-target="#modal-lg" style="float: right;"><i class="fas fa-edit"></i></a></h6>

                        <p style="padding-right: 25px;" class="text-muted text-center">@if($data->role==1)Super Admin  @elseif($data->role==3) Teacher @elseif($data->role==4) Student
                            @endif</p>

                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item">
                                <b>Email</b> <a class="float-right">{{$data->email}}</a>
                            </li>
                            <li class="list-group-item">
                                <b>Phone</b> <a class="float-right">{{$data->phone}}</a>
                            </li>
                            <li class="list-group-item">
                                <b>Gender</b> <a class="float-right">{{$data->gender}}</a>
                            </li>

                            <li class="list-group-item">
                                <b>Joining Date</b> <a class="float-right">{{$data->joining_date}}</a>
                            </li>
                            <li class="list-group-item">
                                <b>Location</b> <a class="float-right">{{$data->address}}</a>
                            </li>

                            <li class="list-group-item text-center">

                                @if($socialdatas->twittter_link == null)<i class="fab fa-twitter"
                                    style="font-size: 25px; padding:5px; "></i>

                                @else<a href="{{$socialdatas->twittter_link}}"><i class="fab fa-twitter"
                                        style="font-size: 25px; padding:5px; "></i></a>
                                @endif

                                @if($socialdatas->facebook_link == null)<i class="fab fa-facebook-f"
                                    style="font-size: 25px; padding:5px; "></i>
                                @else<a href="{{$socialdatas->facebook_link}}"><i class="fab fa-facebook-f"
                                        style="font-size: 25px; padding:5px; "></i></a>@endif

                                @if($socialdatas->linkedin_link == null)<i class="fab fa-linkedin-in"
                                    style="font-size: 25px; padding:5px;"></i>
                                @else<a href="{{$socialdatas->linkedin_link}}"><i class="fab fa-linkedin-in"
                                        style="font-size: 25px; padding:5px; "></i></a>@endif

                                @if($socialdatas->github_link == null)<i class="fab fa-github"
                                    style="font-size: 25px; padding:5px; "></i>
                                @else <a href="{{$socialdatas->github_link}}"><i class="fab fa-github"
                                        style="font-size: 27px; padding:5px; "></i></a> @endif
                            </li>
                        </ul>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- About Me Box -->
                <div class="card card-primary">
                    <div class="card-header text-center">
                        <h3 class="card-title">About Me</h3>
                        <a href="" data-toggle="modal" data-target="#modal-xl-aboutMe"
                            style="float: right; padding:2px;"><i class="fas fa-plus-circle"></i></a>

                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">


                        <strong><i class="fas fa-book mr-1"></i> Education</strong><a href="" data-toggle="modal"
                            data-target="#modal-lg-1" style="float: right;"><i class="fas fa-edit"></i></a>

                        <ul>
                            @foreach ($educationData as $item)

                            @if( $item->e_name !=null && $item->institute_name !=null)
                            <li class="text-muted">
                                {{$item->e_name}} <b>from</b> {{$item->institute_name}}
                            </li>
                            @endif
                            @endforeach

                        </ul>


                        <hr>

                        <strong><i class="fas fa-briefcase mr-1"></i>Experience</strong><a href="" data-toggle="modal"
                            data-target="#modal-lg-2" style="float: right;"><i class="fas fa-edit"></i></a>

                        <ul>
                            @foreach ($expData as $item)
                            <li class="text-muted">
                                {{$item->ex_name}}
                            </li>
                            @endforeach
                        </ul>
                        <hr>

                        <strong><i class="fas fa-pencil-alt mr-1"></i> Skills</strong><a href="" data-toggle="modal"
                            data-target="#modal-lg-3" style="float: right;"><i class="fas fa-edit"></i></a>


                        <ul>
                            @foreach ($skillData as $item)
                            <li> {{$item->s_name}}</li>
                            @endforeach
                        </ul>


                        <hr>

                        <strong><i class="fas fa-heart mr-1"></i>Hobby</strong><a href="" data-toggle="modal"
                            data-target="#default" style="float: right;"><i class="fas fa-edit"></i></a>

                        <ul>
                            @foreach ($hobbyData as $item)
                            <li> {{$item->h_name}} </li>
                            @endforeach
                        </ul>

                        <hr>

                    </div>
                    <!-- /.card-body -->

                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->


            <div class="col-md-9">
                <div class="card card-primary card-outline card-tabs">
                    <div class="card-header p-0 pt-1 border-bottom-0">
                        <ul class="nav nav-tabs">
                            <li class="nav-item"><a class="nav-link active" href="#activity"
                                    data-toggle="tab">Course</a></li>
                            <li class="nav-item"><a class="nav-link" href="#timeline" data-toggle="tab">Enrolment</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="#settings" data-toggle="tab">Accounts</a>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="#communication"
                                    data-toggle="tab">Communication</a>
                            </li>
                        </ul>
                    </div><!-- /.card-header -->

                   
                    <div class="card-body">
                        <div class="tab-content">
                             <!------------------------course------------------------------>
                            <div class="active tab-pane" id="activity">

                                @include('admin.profile.course')

                            </div>
                            <!-- /.tab-pane -->
                             <!------------------------Enrollment------------------------------>
                            <div class="tab-pane" id="timeline">
                                <div class="card-body">
                                    @if($coutGroup>0)
                                    @foreach($courseGroup as $cg)
                                    <h3 class="text-center m-0 text-white" style="background-color:#007bff;">
                                        {{$cg->name}}</h3>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th>Student ID</th>
                                                <th>Student Name</th>
                                                <th>Enrolment date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            @php
                                            $i=1;
                                            @endphp

                                            @foreach($enrolments as $enrolment)
                                            @if($enrolment->course_id == $cg->id)
                                            <tr  @if($enrolment->status==4) style="background-color: #ffc107!important;"@endif >
                                                <td>{{$i++}}</td>
                                                <td>{{$enrolment->student_id}}</td>
                                                <td>{{$enrolment->student->name}}</td>
                                                <td>{{$enrolment->enrolment_date}}</td>
                                                <td>
                                                    <div class="btn-group">
                                                        <button type="button" class="btn btn-info">Action</button>
                                                        <button type="button"
                                                            class="btn btn-info dropdown-toggle dropdown-icon"
                                                            data-toggle="dropdown">
                                                            <span class="sr-only">Toggle Dropdown</span>
                                                        </button>
                                                        <div class="dropdown-menu dropdown-content" role="menu">
                                                            @if($enrolment->status!=4)
                                                            <a class="dropdown-item"
                                                                href="{{url('inactive-enrolment-'.$enrolment->id)}}">
                                                                <i class="fas fa-times-circle"
                                                                    style="padding-right:10px;"></i>Inactive</a>
                                                            @else
                                                            <a class="dropdown-item"
                                                                href="{{url('active-enrolment-'.$enrolment->id)}}">
                                                                <i class="fas fa-check"
                                                                    style="padding-right:10px;"></i>Active</a>
                                                            @endif

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endif
                                            @endforeach

                                        </tbody>
                                    </table>
                                    @endforeach
                                    @else
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th>Student ID</th>
                                                <th>Student Name</th>
                                                <th>Enrolment date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>

                                    </table>
                                    @endif
                                </div>
                            </div>
                            <!-- /.tab-pane -->

                             <!------------------------Accounts------------------------------>
                            <div class="tab-pane" id="settings">
                                @include('admin.profile.teachersAccounts')
                            </div>
                            <!-- /.tab-pane -->

                             <!------------------------Communication------------------------------>
                            <div class="tab-pane" id="communication">
                                <h2>Communication</h2>
                            </div>
                            <!-- /.tab-pane -->
                        </div>
                        <!-- /.tab-content -->
                    </div><!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div><!-- /.container-fluid -->
</section>

<div class="modal fade" id="modal-lg">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Basic Info</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('update-teacher-profile-'.$data->id)}}"
                            enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" name="role" value="{{$data->role}}">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <h5>Full Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="name" class="form-control" required=""
                                                        value="{{$data->name}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <h5>Mobile Number <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="phone" class="form-control" required=""
                                                        value="{{$data->phone}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <h5>Gender <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="gender" id="gender" required="" class="form-control">
                                                        <option value="" selected="" disabled="">Select Gender
                                                        </option>
                                                        <option value="Male"
                                                            {{($data->gender == "Male" ? "selected" : "")}}>Male
                                                        </option>
                                                        <option value="Female"
                                                            {{($data->gender == "Female" ? "selected" : "")}}>Female
                                                        </option>
                                                        <option value="Other"
                                                            {{($data->gender == "Other" ? "selected" : "")}}>Other
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <h5>Date of Birth </h5>
                                                <div class="controls">
                                                    <input type="date" name="dob" class="form-control"
                                                        value="{{$data->dob}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <i class="fab fa-twitter" style="font-size: 25px; padding:5px; "></i>
                                                <div class="controls">
                                                    <input type="text" name="twittter_link" class="form-control"
                                                        value="{{$socialdatas->twittter_link}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 3 -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <i class="fab fa-facebook-f" style="font-size: 25px; padding:5px; "></i>
                                                <div class="controls">
                                                    <input type="text" name="facebook_link" class="form-control"
                                                        value="{{$socialdatas->facebook_link}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 3 -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <i class="fab fa-linkedin-in"
                                                    style="font-size: 25px; padding:5px; "></i>
                                                <div class="controls">
                                                    <input type="text" name="linkedin_link" class="form-control"
                                                        value="{{$socialdatas->linkedin_link}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 3 -->
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <i class="fab fa-github" style="font-size: 25px; padding:5px; "></i>
                                                <div class="controls">
                                                    <input type="text" name="github_link" class="form-control"
                                                        value="{{$socialdatas->github_link}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 3 -->


                                    </div> <!-- End 3rd Row -->
                                    <div class="row">
                                        <!-- 4th Row -->


                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Profile Image</h5>
                                                <div class="controls">
                                                    <input type="file" name="image" class="form-control" id="image"
                                                        value="{{$data->image}}">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <img id="showImage"
                                                        src="{{(!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')}}"
                                                        style="width: 100px; height: 110px; border: 1px solid #000000;">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 4th Row -->

                                    <div class="row">
                                        <!-- 6TH Row -->

                                    </div> <!-- End 6TH Row -->
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<div class="modal fade" id="modal-xl-aboutMe">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Update About Me</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('update-teacher-aboutme-'.$data->id)}}"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <h5><b>Education List:</b></h5>
                                        <div class="col-12">
                                            <!-- 1st Row -->

                                            <div class="add_item">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Name <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="e_name[]" class="form-control"
                                                                    required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <h5>Institute <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="institute_name[]"
                                                                    class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->

                                                    <div class="col-md-2"
                                                        style="padding-top:30px; padding-bottom:15px;">
                                                        <span class="btn btn-success addeventmore">
                                                            <i class="fa fa-plus-circle"></i>
                                                        </span>
                                                    </div>
                                                    <!----//Col-1 End----->
                                                </div>


                                            </div>
                                        </div>

                                    </div> <!-- End 1stRow -->

                                    <div class="row">
                                        <!-- 2nd Row -->
                                        <h5><b>Experience List:</b></h5>
                                        <div class="col-12">

                                            <div class="add_item1">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Experience Name<span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="ex_name[]" class="form-control"
                                                                    required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <h5>Docoment <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="document[]"
                                                                    class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->

                                                    <div class="col-md-2"
                                                        style="padding-top:30px; padding-bottom:15px;">
                                                        <span class="btn btn-success addeventmore1">
                                                            <i class="fa fa-plus-circle"></i>
                                                        </span>
                                                    </div>
                                                    <!----//Col-1 End----->
                                                </div>
                                            </div>
                                        </div>

                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <h5><b>Skill List:</b></h5>
                                        <div class="col-12">
                                            <!-- 3rd Row -->
                                            <div class="add_item2">

                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Skill Name <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="s_name[]" class="form-control"
                                                                    required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <h5>Docoment <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="s_document[]"
                                                                    class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->

                                                    <div class="col-md-2"
                                                        style="padding-top:30px; padding-bottom:15px;">
                                                        <span class="btn btn-success addeventmore2">
                                                            <i class="fa fa-plus-circle"></i>
                                                        </span>
                                                    </div>
                                                    <!----//Col-1 End----->
                                                </div>

                                            </div>
                                        </div>

                                    </div> <!-- End 3rd Row -->

                                    <div class="row">
                                        <h5><b>Hobby List:</b></h5>
                                        <div class="col-12">
                                            <!-- 3rd Row -->
                                            <div class="add_item3">

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <h5>Hobby <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="h_name[]" class="form-control"
                                                                    required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->

                                                    <div class="col-md-3"
                                                        style="padding-top:30px; padding-bottom:15px;">
                                                        <span class="btn btn-success addeventmore3">
                                                            <i class="fa fa-plus-circle"></i>
                                                        </span>
                                                    </div>
                                                    <!----//Col-1 End----->
                                                </div>


                                            </div>
                                        </div>

                                    </div> <!-- End 3rd Row -->



                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>

                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<!-- /.Education Edit modal -->
<div class="modal fade" id="modal-lg-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Education</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <form method="post" action="{{url('update-teacher-education-'.$data->id)}}">
                    @csrf

                    <input type="hidden" name="check" value="{{$countx}}">
                    <div class="row">
                        <div class="col-12">

                            <div class="add_item">

                                @if($countx >0)

                                @foreach ($educationData as $item)

                                <input type="hidden" name="eduId[]" value="{{$item->id}}">

                                <div class="row" id="itemDiv">

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Name <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="e_name[]" class="form-control" required=""
                                                    value="{{$item->e_name}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Institute <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="institute_name[]" class="form-control"
                                                    required="" value="{{$item->institute_name}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>

                                        <a href="{{url('delete-teacher-education-'.$item->id)}}" id="delete">
                                            <span class="btn btn-danger" id="deleteIteam">
                                                <i class="fas fa-trash-alt"></i>
                                            </span></a>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>
                                @endforeach

                                @else
                                <input type="hidden" name="eduId[]">

                                <div class="row" id="itemDiv">

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Name <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="e_name[]" class="form-control" required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Institute <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="institute_name[]" class="form-control"
                                                    required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>

                                    </div>
                                    <!----//Col-1 End----->
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="row" style="margin-top: 20px">
                            <!-- 7TH Row -->
                            <div class="col-md-5">
                                <div class="text-xs-right">
                                    <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                </div>
                            </div>

                        </div> <!-- End 7TH Row -->
                    </div>

                </form>
            </div>

        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- /.Experience Edit modal -->
<div class="modal fade" id="modal-lg-2">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Experience</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <form method="post" action="{{url('update-teacher-experience-'.$data->id)}}">
                    @csrf

                    <input type="hidden" name="check" value="{{$countExp}}">
                    <div class="row">
                        <div class="col-12">

                            <div class="add_item1">

                                @if($countExp>0)
                                @foreach ($expData as $item)

                                <input type="hidden" name="expId[]" value="{{$item->id}}">
                                <div class="row" id="itemDiv">

                                    <input type="hidden" value="{{$item->id}}" name="id" id="id">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Name <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="ex_name[]" class="form-control" required=""
                                                    value="{{$item->ex_name}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Document <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="document[]" class="form-control" required=""
                                                    value="{{$item->document}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore1">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                        <a href="{{url('delete-teacher-experience-'.$item->id)}}" id="delete">
                                            <span class="btn btn-danger" id="deleteIteam">
                                                <i class="fas fa-trash-alt"></i>
                                            </span></a>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>

                                @endforeach
                                @else
                                <div class="row" id="itemDiv">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Name <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="ex_name[]" class="form-control" required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Document <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="document[]" class="form-control" required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore1">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>
                                @endif
                            </div>
                        </div>


                        <div class="row" style="margin-top: 20px">
                            <!-- 7TH Row -->
                            <div class="col-md-5">
                                <div class="text-xs-right">
                                    <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                </div>
                            </div>

                        </div> <!-- End 7TH Row -->
                    </div>

                </form>
            </div>

        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- /.Skill Edit modal -->
<div class="modal fade" id="modal-lg-3">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Skill</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <form method="post" action="{{url('update-teacher-Skill-'.$data->id)}}">
                    @csrf

                    <input type="hidden" name="check" value="{{$countSkill}}">
                    <div class="row">
                        <div class="col-12">

                            <div class="add_item2">
                                @if($countSkill>0)

                                @foreach ($skillData as $item)
                                <input type="hidden" name="skillId[]" value="{{$item->id}}">
                                <div class="row" id="itemDiv">

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Skill Name<span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="s_name[]" class="form-control" required=""
                                                    value="{{$item->s_name}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Document <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="s_document[]" class="form-control" required=""
                                                    value="{{$item->s_document}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore2">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                        <a href="{{url('delete-teacher-skill-'.$item->id)}}" id="delete">
                                            <span class="btn btn-danger" id="deleteIteam">
                                                <i class="fas fa-trash-alt"></i>
                                            </span></a>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>

                                @endforeach

                                @else
                                <div class="row" id="itemDiv">

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Skill Name<span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="s_name[]" class="form-control" required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Document <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="s_document[]" class="form-control" required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore2">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                        <span class="btn btn-danger" id="deleteIteam">
                                            <i class="fas fa-trash-alt"></i>
                                        </span>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>
                                @endif
                            </div>
                        </div>


                        <div class="row" style="margin-top: 20px">
                            <!-- 7TH Row -->
                            <div class="col-md-5">
                                <div class="text-xs-right">
                                    <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                </div>
                            </div>

                        </div> <!-- End 7TH Row -->
                    </div>

                </form>
            </div>

        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- /.Hobby Edit modal -->
<div class="modal fade" id="default">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Hobby</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <form method="post" action="{{url('update-teacher-hobby-'.$data->id)}}">
                    @csrf

                    <input type="hidden" name="check" value="{{$countHobby}}">

                    <div class="row">
                        <div class="col-12">

                            <div class="add_item3">
                                @if($countHobby>0)

                                @foreach ($hobbyData as $item)

                                <input type="hidden" name="hobbyId[]" value="{{$item->id}}">

                                <div class="row" id="itemDiv">

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Hobby<span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="h_name[]" class="form-control" required=""
                                                    value="{{$item->h_name}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-3" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore3">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                        <a href="{{url('delete-teacher-hobby-'.$item->id)}}" id="delete">
                                            <span class="btn btn-danger" id="deleteIteam">
                                                <i class="fas fa-trash-alt"></i>
                                            </span></a>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>

                                @endforeach

                                @else
                                <div class="row" id="itemDiv">

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <h5>Hobby<span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="h_name[]" class="form-control" required="">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-3" style="padding-top:30px; padding-bottom:15px;">
                                        <span class="btn btn-success addeventmore3">
                                            <i class="fa fa-plus-circle"></i>
                                        </span>
                                    </div>
                                    <!----//Col-1 End----->
                                </div>
                                @endif
                            </div>
                        </div>


                        <div class="row" style="margin-top: 20px">
                            <!-- 7TH Row -->
                            <div class="col-md-5">
                                <div class="text-xs-right">
                                    <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                </div>
                            </div>

                        </div> <!-- End 7TH Row -->
                    </div>

                </form>
            </div>

        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-------------add more education------------>
<div style="visibility:hidden;">
    <div class="whole_extra_item_add" id="whole_extra_item_add">
        <div class="delete_whole_extra_item_add" id="delete_whole_extra_item_add">
            <div class="row">

                <div class="col-md-4">
                    <div class="form-group">
                        <h5>Name <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="e_name[]" class="form-control" required="" value="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->
                <div class="col-md-6">
                    <div class="form-group">
                        <h5>Institute <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="institute_name[]" class="form-control" required="" value="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->

                <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                    <span class="btn btn-success addeventmore">
                        <i class="fa fa-plus-circle"></i>
                    </span>
                    <span class="btn btn-danger removeeventmore">
                        <i class="fa fa-minus-circle"></i>
                    </span>
                </div>
                <!----//Col-1 End----->
            </div>
        </div>
    </div>
</div>

<!-------------add more Experience------------>

<div style="visibility:hidden;">
    <div class="whole_extra_item_add" id="whole_extra_item_add1">
        <div class="delete_whole_extra_item_add" id="delete_whole_extra_item_add">
            <div class="row">

                <div class="col-md-4">
                    <div class="form-group">
                        <h5>Experience Name<span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="ex_name[]" class="form-control" required="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->
                <div class="col-md-6">
                    <div class="form-group">
                        <h5>Docoment <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="document[]" class="form-control" required="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->

                <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                    <span class="btn btn-success addeventmore1">
                        <i class="fa fa-plus-circle"></i>
                    </span>
                    <span class="btn btn-danger removeeventmore1">
                        <i class="fa fa-minus-circle"></i>
                    </span>
                </div>
                <!----//Col-1 End----->
            </div>
        </div>
    </div>
</div>

<!-------------add more Skill------------>
<div style="visibility:hidden;">
    <div class="whole_extra_item_add" id="whole_extra_item_add2">
        <div class="delete_whole_extra_item_add" id="delete_whole_extra_item_add">
            <div class="row">

                <div class="col-md-4">
                    <div class="form-group">
                        <h5>Skill Name<span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="s_name[]" class="form-control" required="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->
                <div class="col-md-6">
                    <div class="form-group">
                        <h5>Docoment <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="s_document[]" class="form-control" required="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->

                <div class="col-md-2" style="padding-top:30px; padding-bottom:15px;">
                    <span class="btn btn-success addeventmore2">
                        <i class="fa fa-plus-circle"></i>
                    </span>
                    <span class="btn btn-danger removeeventmore2">
                        <i class="fa fa-minus-circle"></i>
                    </span>
                </div>
                <!----//Col-1 End----->
            </div>
        </div>
    </div>
</div>

<!-------------add more hobby------------>
<div style="visibility:hidden;">
    <div class="whole_extra_item_add" id="whole_extra_item_add3">
        <div class="delete_whole_extra_item_add" id="delete_whole_extra_item_add">
            <div class="row">

                <div class="col-md-6">
                    <div class="form-group">
                        <h5>Hobby<span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="h_name[]" class="form-control" required="">
                        </div>
                    </div>
                </div> <!-- End Col md 4 -->


                <div class="col-md-3" style="padding-top:30px; padding-bottom:15px;">
                    <span class="btn btn-success addeventmore3">
                        <i class="fa fa-plus-circle"></i>
                    </span>
                    <span class="btn btn-danger removeeventmore3">
                        <i class="fa fa-minus-circle"></i>
                    </span>
                </div>
                <!----//Col-1 End----->
            </div>
        </div>
    </div>
</div>




<script type="text/javascript">
    $(document).ready(function () {
        $('#image').change(function (e) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#showImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    });

</script>

<!------------Education------------------>
<script type="text/javascript">
    $(document).ready(function () {
        var counter = 0;
        $(document).on('click', '.addeventmore', function () {
            var whole_extra_item_add = $('#whole_extra_item_add').html();
            $(this).closest('.add_item').append(whole_extra_item_add);
            counter++;
        });
        $(document).on('click', '.removeeventmore', function () {
            $(this).closest('.delete_whole_extra_item_add').remove();
            counter -= 1;
        });
    });

</script>

<!-------------------------Experience--------------------------->
<script type="text/javascript">
    $(document).ready(function () {
        var counter = 0;
        $(document).on('click', '.addeventmore1', function () {
            var whole_extra_item_add = $('#whole_extra_item_add1').html();
            $(this).closest('.add_item1').append(whole_extra_item_add);
            counter++;
        });
        $(document).on('click', '.removeeventmore1', function () {
            $(this).closest('.delete_whole_extra_item_add').remove();
            counter -= 1;
        });
    });

</script>

<!-------------------------Skill--------------------------->
<script type="text/javascript">
    $(document).ready(function () {
        var counter = 0;
        $(document).on('click', '.addeventmore2', function () {
            var whole_extra_item_add = $('#whole_extra_item_add2').html();
            $(this).closest('.add_item2').append(whole_extra_item_add);
            counter++;
        });
        $(document).on('click', '.removeeventmore2', function () {
            $(this).closest('.delete_whole_extra_item_add').remove();
            counter -= 1;
        });
    });

</script>

<!-------------------------Hobby--------------------------->
<script type="text/javascript">
    $(document).ready(function () {
        var counter = 0;
        $(document).on('click', '.addeventmore3', function () {
            var whole_extra_item_add = $('#whole_extra_item_add3').html();
            $(this).closest('.add_item3').append(whole_extra_item_add);
            counter++;
        });
        $(document).on('click', '.removeeventmore3', function () {
            $(this).closest('.delete_whole_extra_item_add').remove();
            counter -= 1;
        });
    });

</script>
{{-- 
<script>
    $(document).ready(function () {
        $(document).on('click', '#deleteIteam', function () {
            $(this).closest('#itemDiv').remove();
        });
    });

</script> --}}

@endsection
