@extends('admin.masterBlade')

@section('title')
New Order
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">New Order
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <div class="modal-body">
                            <div class="row">
                                <div class="col">
                                    <form method="post" action="{{url('store-client-order')}}" enctype="multipart/form-data">
                                        @csrf
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="row">
                                                    <!-- 1st Row -->
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>App Link <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="apps_link" class="form-control"
                                                                    required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Platform <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <select name="platform" id="platform" required=""
                                                                    class="form-control">
                                                                    <option value="" selected="" disabled="">Select Platfrom
                                                                    </option>
                                                                    <option value="Android">Android</option>
                                                                    <option value="IOS">IOS</option>
                                                                    <option value="Google">Google</option>
                                                                    <option value="Others">Others</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Service Type <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <select name="service_type_id" id="service_type_id" required=""
                                                                    class="form-control">
                                                                    <option value="" selected="" disabled="">Select Service Type
                                                                    </option>
                                                                    @foreach ($service as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
            
                                                </div> <!-- End 1stRow -->
            
                                                <div class="row" id="calculation">
                                                    <!-- 2nd Row -->
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Quantity <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="number" name="total_quantity" id="total_quantity"
                                                                    class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Service Cost(/Work) <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="number" step="0.0001" name="service_cost"
                                                                    id="service_cost" class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Budget <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="number" name="total_budget" id="total_budget"
                                                                    class="form-control" readonly required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                </div> <!-- End 2nd Row -->
            
                                                <div class="row">
                                                    <!-- 3rd Row -->
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Per Day Work <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="number" name="perday" class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>KeyWord</h5>
                                                            <div class="controls">
                                                                <input type="text" name="key_word" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>GEO <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="text" name="geo" class="form-control" required="">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
            
                                                </div> <!-- End 3rd Row -->
            
                                                <div class="row">
                                                    <!-- 4th Row -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Comment</h5>
                                                            <div class="controls">
                                                                <textarea type="text" name="comment" class="form-control"
                                                                    id="image"></textarea>
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Dalivary Date <span class="text-danger">*</span></h5>
                                                            <div class="controls">
                                                                <input type="date" id="date_picker" name="target_date" required class="form-control">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
                                                    <!-- 4th Row -->
            
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <h5>Document</h5>
                                                            <div class="controls">
                                                                <input type="file" name="file" class="form-control" id="image">
                                                            </div>
                                                        </div>
                                                    </div> <!-- End Col md 4 -->
            
                                                </div> <!-- End 4th Row -->
                                            </div>
                                        </div>
                                        <div class="row" style="margin-top: 20px">
                                            <!-- 7TH Row -->
                                            <div class="col-md-5">
                                                <div class="text-xs-right">
                                                    <input type="submit" id="submit" class="btn btn-rounded btn-primary mb-5"
                                                        value="Submit">
                                                </div>
                                            </div>
                                        </div> <!-- End 7TH Row -->
                                    </form>
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">

      $("#calculation").on("keyup click", function()
      {
        var qty = parseFloat($('#total_quantity').val());
        var price = parseFloat($('#service_cost').val());

        var unit_total = parseFloat(qty * price);

        $("#total_budget").val(unit_total.toFixed(2));
      });
</script>

@endsection
