@extends('admin.masterBlade')

@section('title')
Clients Orders
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row" style="margin-top:10px;">
            <div class="col-md-12 col-sm-6">
                <div class="card card-success card-tabs">
                    <div class="card-header p-0 pt-1">
                        <ul class="nav flex-row nav-tabs nav-tabs-right" id="custom-tabs-one-tab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="custom-tabs-one-home-tab" data-toggle="pill"
                                    href="#order" role="tab" aria-controls="custom-tabs-one-home"
                                    aria-selected="true">Order List</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-profile-tab" data-toggle="pill"
                                    href="#order-pending" role="tab" aria-controls="custom-tabs-one-profile"
                                    aria-selected="false">Pending Order</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-messages-tab" data-toggle="pill"
                                    href="#order-accept" role="tab" aria-controls="custom-tabs-one-messages"
                                    aria-selected="false">Accept Order</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-messages-tab" data-toggle="pill"
                                    href="#order-progress" role="tab" aria-controls="custom-tabs-one-messages"
                                    aria-selected="false">Progress Order</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-settings-tab" data-toggle="pill"
                                    href="#order-finished" role="tab" aria-controls="custom-tabs-one-settings"
                                    aria-selected="false">Completed order</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-settings-tab" data-toggle="pill"
                                    href="#order-hold" role="tab" aria-controls="custom-tabs-one-settings"
                                    aria-selected="false">Hold Order</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-settings-tab" data-toggle="pill"
                                    href="#order-reject" role="tab" aria-controls="custom-tabs-one-settings"
                                    aria-selected="false">Rejected Order</a>
                            </li>

                            <li class="nav-item float-right" style="float: right">
                                <a class="nav-link" href="#" title="Add New Order" data-toggle="modal"
                                    data-target="#modal-xl">
                                    <b class="fas fa-plus-circle" style="font-size:21px;"></b>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content" id="custom-tabs-one-tabContent">
                            <div class="tab-pane fade show active" id="order" role="tabpanel"
                                aria-labelledby="custom-tabs-one-home-tab">
                                @include('client.order.orderList')
                            </div>
                            <div class="tab-pane fade" id="order-pending" role="tabpanel"
                                aria-labelledby="custom-tabs-one-profile-tab">
                                @include('client.order.pending')
                            </div>
                            <div class="tab-pane fade" id="order-accept" role="tabpanel"
                                aria-labelledby="custom-tabs-one-messages-tab">
                                @include('client.order.accept')
                            </div>
                            <div class="tab-pane fade" id="order-progress" role="tabpanel"
                                aria-labelledby="custom-tabs-one-settings-tab">
                                @include('client.order.progress')
                            </div>
                            <div class="tab-pane fade" id="order-finished" role="tabpanel"
                                aria-labelledby="custom-tabs-one-settings-tab">
                                @include('client.order.finished')
                            </div>
                            <div class="tab-pane fade" id="order-hold" role="tabpanel"
                                aria-labelledby="custom-tabs-one-settings-tab">
                                @include('client.order.hold')
                            </div>
                            <div class="tab-pane fade" id="order-reject" role="tabpanel"
                                aria-labelledby="custom-tabs-one-settings-tab">
                                @include('client.order.reject')
                            </div>
                        </div>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="modal-xl">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Order</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" id="odrForm" action="{{url('store-client-order')}}"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>App Link <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="apps_link" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Platform <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="platform" id="platform" required=""
                                                        class="form-control">
                                                        <option value="" selected="" disabled="">Select Platfrom
                                                        </option>
                                                        <option value="Android">Android</option>
                                                        <option value="IOS">IOS</option>
                                                        <option value="Google">Google</option>
                                                        <option value="Others">Others</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Service Type <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="service_type_id" id="service_type_id" required=""
                                                        class="form-control">
                                                        <option value="" selected="" disabled="">Select Service Type
                                                        </option>
                                                        @foreach ($service as $item)
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->


                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Quantity <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_quantity" id="total_quantity"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Service Cost(/Work) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" step="0.0001" name="service_cost"
                                                        id="service_cost" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Budget <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_budget" id="total_budget"
                                                        class="form-control" step="0.0001" readonly required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Per Day Work <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="perday" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>KeyWord</h5>
                                                <div class="controls">
                                                    <input type="text" name="key_word" class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>GEO <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="geo" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->


                                    </div> <!-- End 3rd Row -->

                                    <div class="row">
                                        <!-- 4th Row -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Start Date <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" name="start_date" required
                                                        class="form-control min_today">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Dalivary Date <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" id="date_picker" name="target_date" required
                                                        class="form-control">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Document</h5>
                                                <div class="controls">
                                                    <input type="file" name="file" class="form-control" id="image">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Comment</h5>
                                                <div class="controls">
                                                    <textarea type="text" name="comment" class="form-control"
                                                        id="image"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                    </div> <!-- End 4th Row -->
                                </div>
                            </div>
                            <div class="row" style="margin-top: 20px">
                                <!-- 7TH Row -->
                                <div class="col-md-5">
                                    <div class="text-xs-right">
                                        <input type="submit" id="submit" class="btn btn-rounded btn-primary mb-5"
                                            value="Submit">
                                    </div>
                                </div>
                            </div> <!-- End 7TH Row -->
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script type="text/javascript">
$('#odrForm').submit(function() {
    $(this).find(':submit').attr('disabled', 'disabled');
    //the rest of your code
    setTimeout(() => {
        $(this).find(':submit').attr('disabled', false);
    }, 2000)
});

$("#calculation").on("keyup click", function() {
    var qty = parseFloat($('#total_quantity').val());
    var price = parseFloat($('#service_cost').val());

    var unit_total = parseFloat(qty * price);

    $("#total_budget").val(unit_total.toFixed(4));
});
</script>



@endsection