<!DOCTYPE html>
<html lang="en">

<head>
    <title>Order Status Information</title>
    <style type="text/css">
    img {
        display: block;
        margin-left: auto;
        margin-right: auto;
    }

    #table_design {
        font-family: Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #table_design td,
    #table_design th {
        border: 2px solid #ddd;
        padding: 8px;
    }

    #table_design tr:nth-child(even) {
        background-color: #f2f2f2;
    }

    #table_design tr:hover {
        background-color: #ddd;
    }

    #table_design th {
        font-size: 16px;
        padding-top: 5px;
        padding-bottom: 5px;
        text-align: left;
        background-color: #cccccc;
        color: black;
    }

    #t_design {
        font-family: Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
        border-radius: 25px;
    }

    #t_design td,
    #t_design th {
        border: 1px solid rgba(221, 221, 221, 0.349);
        padding: 5px;
    }

    #t_design tr:nth-child(even) #t_design tr:hover {
        background-color: #ddd;
    }

    #t_design th {
        font-size: 17px;
        padding-top: 5px;
        padding-bottom: 5px;
        text-align: left;
        color: black;
    }

    .center {
        display: block;
        margin-left: auto;
        margin-right: auto;
        width: 80%;
        height: auto;
        margin-bottom: 50px;
    }

    .quote {
        display: block;
        margin-left: auto;
        margin-right: auto;
        width: 80%;
        height: auto;
        margin-top: 25px;
    }

    pre {
        font-family: Georgia;
        font-size: 15px;
        color: #000000;
        background-color: inherit;
        border: none;
        overflow-wrap: break-word;
        text-align: center;
        font-weight: bold;
    }
    </style>

</head>

<div class="container">
    <div class="row">
        <div class="col-md-12 col-md-12 body-mainn">
            <div class="col-md-12"
                style="border: 1px solid #030087;height: auto; margin-top: 0px;margin-bottom: 0px;position: relative;padding: 40px 30px !important; box-shadow: 0 1px 21px #808080;">
                <div class="row">
                    <div class="center">
                        <div class="text-center" style="font-family: Georgia;">
                            <pre><h1 style="color: #030087; font-weight: bold;"><u>Mail From Customer Relationship Management (CRM)</u></h1></pre>
                        </div>
                        <div style="font-family: Georgia; font-size: 16px; padding-top: 20px;">
                            <p><strong>Hi there, Mr. {{ $getVendor->name }} </strong></p>
                            <p>Here is the Order Status information for Order number {{ $getOrder->order_unique_id }} .
                                Below are the details for your Order.</p>
                            <p>
                                Current Order Status is :
                                {{-- <span style="color: rgb(7, 191, 26)"><b>Complete</b></span> --}}

                                @if($getOrder->order_status ==1)
                                <span style="color: rgb(227, 2, 2)"><b>Pending</b></span>
                                @elseif($getOrder->order_status ==2)
                                <span style="color: rgb(227, 2, 2)"><b>Accept</b></span>
                                @elseif($getOrder->order_status ==3)
                                <span style="color: rgb(227, 2, 2)"><b>In Work</b></span>
                                @elseif($getOrder->order_status ==4)
                                <span style="color: rgb(227, 2, 2)"><b>Finished</b></span>
                                @elseif($getOrder->order_status ==5)
                                <span style="color: rgb(227, 2, 2)"><b>Refilling</b></span>
                                @elseif($getOrder->order_status ==6)
                                <span style="color: rgb(227, 2, 2)"><b>Refiled</b></span>
                                @elseif($getOrder->order_status ==7)
                                <span style="color: rgb(227, 2, 2)"><b>Hold</b></span>
                                @elseif($getOrder->order_status ==8)
                                <span style="color: rgb(227, 2, 2)"><b>Decline</b></span>
                                @elseif($getOrder->order_status ==9)
                                <span style="color: rgb(227, 2, 2)"><b>Active</b></span>
                                @elseif($getOrder->order_status ==10)
                                <span style="color: rgb(227, 2, 2)"><b>Complete</b></span>
                                @elseif($getOrder->order_status ==11)
                                <span style="color: rgb(227, 2, 2)"><b>Canceled</b></span>
                                @else
                                <span style="color: rgb(227, 2, 2)"><b>N/A</b></span>
                                @endif

                            </p>
                            <h3 style="font-weight: bold; color: #030087;"><u><i>Order Information</i></u></h3>
                        </div>

                        <table id="t_design" style="font-size: 14px;">
                            <thead>
                                <tr>
                                    <td colspan="4" class="text-left">ID: {{ $getOrder->order_unique_id }} </td>
                                    <td colspan="4" class="text-left">Quantity: {{ $getOrder->total_quantity }} </td>
                                    <td colspan="4" class="text-left">Last Date: {{ $getOrder->target_date }} </td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="text-left">Service Type: {{ $getOrder->service->name }} </td>
                                    <td colspan="4" class="text-left">Per day work: {{ $getOrder->perday }} </td>
                                    <td colspan="4" class="text-left">Progress:
                                        {{ $getOrder->workCount }}/{{ $getOrder->total_quantity }} </td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="text-left">GEO: {{ $getOrder->geo }}</td>
                                    <td colspan="4" class="text-left">Service Cost: ${{ $getOrder->service_cost }} </td>
                                    <td colspan="4" class="text-left"><b>Status:</b>
                                        {{-- <span style="color: rgb(7, 191, 26)"><b>Complete</b></span> --}}

                                        @if($getOrder->order_status ==1)
                                        <span style="color: rgb(227, 2, 2)"><b>Pending</b></span>
                                        @elseif($getOrder->order_status ==2)
                                        <span style="color: rgb(227, 2, 2)"><b>Accept</b></span>
                                        @elseif($getOrder->order_status ==3)
                                        <span style="color: rgb(227, 2, 2)"><b>In Work</b></span>
                                        @elseif($getOrder->order_status ==4)
                                        <span style="color: rgb(227, 2, 2)"><b>Finished</b></span>
                                        @elseif($getOrder->order_status ==5)
                                        <span style="color: rgb(227, 2, 2)"><b>Refilling</b></span>
                                        @elseif($getOrder->order_status ==6)
                                        <span style="color: rgb(227, 2, 2)"><b>Refiled</b></span>
                                        @elseif($getOrder->order_status ==7)
                                        <span style="color: rgb(227, 2, 2)"><b>Hold</b></span>
                                        @elseif($getOrder->order_status ==8)
                                        <span style="color: rgb(227, 2, 2)"><b>Decline</b></span>
                                        @elseif($getOrder->order_status ==9)
                                        <span style="color: rgb(227, 2, 2)"><b>Active</b></span>
                                        @elseif($getOrder->order_status ==10)
                                        <span style="color: rgb(227, 2, 2)"><b>Complete</b></span>
                                        @elseif($getOrder->order_status ==11)
                                        <span style="color: rgb(227, 2, 2)"><b>Canceled</b></span>
                                        @else
                                        <span style="color: rgb(227, 2, 2)"><b>N/A</b></span>
                                        @endif

                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="text-left">Platform: {{ $getOrder->platform }}</td>
                                    <td colspan="4" class="text-left">Total Budget: ${{ $getOrder->total_budget }}</td>
                                    <td colspan="4" class="text-left">Keyword: {{ $getOrder->key_word }}</td>
                                </tr>
                            </thead>
                        </table>

                        <div style="font-family: Georgia; font-size: 16px; padding-top: 20px;">
                            <p>This is a Order Status information message.</p>
                        </div>

                        <div style="font-family: Georgia; font-size: 16px; padding-top: 20px;">
                            <h4>Best Regards, </h4>
                            <p>Lutfur Hasan</p>
                            <p>CEO </p>
                            <p>Pro Review </p>
                            <p>Skype: Buyreview </p>
                            <p>E-Mail: mailto:lutfurhasan@proreview.com </p>
                            <p>Website: https://www.proreviewapps.com</p>
                        </div>

                    </div>
                </div>
            </div>
            <div class="invoice-footer">
                <div style="font-size: 10px; float: left;" class="col-md-8">
                    <p><strong>Customer Relationship Management : https://www.proreviewapps.com</strong></p>
                </div>
                <div style="font-size: 10px; float: right;" class="col-md-4">
                    <p><strong>Technical Support : https://lutfurhasan.com</strong></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- <script type="text/javascript">
      window.onload = function() { window.print(); }
    </script> -->

</body>

</html>