@if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 ||Auth::user()->role == 6 )
@extends('admin.masterBlade')

@section('title')
Assign Order List
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Add Text List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Unique Id</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Comment</th>
                                    <th>File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
        
                                    <td>{{$data->order_unique_id}}</td>
                                    <td><a href="{{$data->apps_link }}" target="_blank" >Link</a></td>
                                    <td>{{$data->platform}}</td>
                                    <td>{{$data->geo}}</td>
                                    <td>{{$data->s_name}}</td>
                                    <td>{{$data->target_date}}</td>
                                    <td>{{$data->total_quantity}}</td>

                                    <td>{{$data->perday}}</td>
                                    <td>{{$data->key_word}}</td>
                                    
                                    <td>
                                        <input id="exp{{$key+1}}" class="exp"  type="checkbox">
                                        <div class="text">
                                            <label class="btns" for="exp{{$key+1}}"></label>
                                            {{$data->comment}}
                                        </div>
                                    </td>

                                    <td>@if($data->file != null)<a  href="{{asset('upload/orderFile/'.$data->file)}}" download>{{$data->file}}<input type="hidden" id="fileValue" value="{{$data->file}}"></a>@else No File @endif</td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                               
                                                @if($data->file == null)
                                                    <a class="dropdown-item"  data-toggle="modal" data-target="#modal-fileAdd"
                                                    onclick="getOrderId2({{$data->id}})" ><i
                                                        class="fas fa-check" style="padding-right:10px;"></i>Add Text/file</a>
                                                @else
                                                    <a class="dropdown-item"  data-toggle="modal" data-target="#modal-fileEdit"
                                                    onclick="editFile({{$data->id}})" ><i
                                                        class="fas fa-edit" style="padding-right:10px;"></i>Edit Text/file</a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="modal-fileAdd">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add File</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('upload-order-text')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="order_id" id="id2">
                            <div class="row">
                                <div class="col-12">

                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Upload File<span class="text-danger">*</span></h5>
                                                <input type="file" name="file" class="form-control" required="">
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="modal-fileEdit">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit File</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('upload-order-text')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="order_id" id="id3">
                            <div class="row">
                                <div class="col-12">

                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Upload File<span class="text-danger">*</span></h5>
                                                <input type="file" name="fileX" class="form-control" required="">

                                                <div class="row" id="extra">
                                                    <div class="col-md-10">
                                                        <input type="text" id="file12" class="form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <a href="javascript:void(0)" onclick="deleteFile()" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<script>
function getOrderId2(r)
{
   console.log(r);
   $("#id2").val(r);
}

function editFile(r)
{
   console.log(r);
   var id =r;
   $("#id3").val(id);
   //console.log(id);

   if (id != '') {
            $.ajax({
                url: "getValueFromOrder",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data) {
                    console.log(data);
                    $("#file12").val(data.file);
                    $("#id3").val(data.id);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
}

function deleteFile()
    {
       var id = $("#id3").val();
       console.log(id);
    
       if (id != '') {
            $.ajax({
                url: "deleteFileFromOrder",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data)
                {
                    console.log(data);
                    var div = document.getElementById('extra');
                    if (div.style.display !== 'none') {
                        div.style.display = 'none';
                    }
                    else {
                        div.style.display = 'block';
                    }
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

@endsection


@else
@include('admin.404')
@endif
