<?php
    $findRole = DB::table('admin_role')->where('url', 'In-progress-orders-v')->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Pending Order List
@endsection

@section('content')
    @if($findRole != null )

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-success table-responsive" style="margin-top:20px;">

                            <div class="card-header text-center">
                                <h5 class="m-0 text-white">Pending Order List
                                    <a href="javascript:history.back()">
                                        <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                                    </a>
                                </h5>
                            </div>

                            <!-- /.card-header -->
                            <div class="card-body">
                                <!-----------------------Active/Inactive Button--------------------->
                                <table id="example1" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                            <th>Assign Uni_Id</th>
                                            <th>Order Id</th>
                                            <th>Total Quantity</th>
                                            <th>Rate</th>
                                            <th>Budget</th>
                                            <th>Service</th>
                                            <th>Targeted Date</th>
                                            <th>App Link</th>
                                            <th>Platfrom</th>
                                            <th>GEO</th>
                                            <th>Per Day</th>
                                            <th>Status</th>
                                            <th>File</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($datas as $key=>$data)
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td><a href="#" target="_blank" >{{$data->unique_id}}</a></td>
                                            <td><a href="#" target="_blank" >{{$data->order_unique_id}}</a></td>
                                            <td>{{$data->total_quantity}}</td>
                                            <td>{{number_format($data->vendor_rate, 2)}}</td>
                                            <td>{{number_format($data->total_service_cost, 2)}}</td>
                                            <td>{{$data->name}}</td>
                                            <td>{{$data->target_date}}</td>
                                            <td><a href="{{$data->apps_link}}" target="_blank" >Click Here</a></td>
                                            <td>{{$data->platform}}</td>
                                            <td>{{$data->geo}}</td>
                                            <td>{{$data->perday}}</td>
                                            <td>
                                                @if($data->v_work_status ==1)<span class="textSize badge badge-warning">Pending @if($data->notify != null){{$data->notify}}@endif</span>
                                                @elseif($data->v_work_status ==2)<span class="textSize badge badge-info">Accept</span>
                                                @elseif($data->v_work_status ==3)<span class="textSize badge badge-success">In Process</span>
                                                @elseif($data->v_work_status ==4)<span class="textSize badge badge-warning ">Finished</span>
                                                @elseif($data->v_work_status ==5)<span class="textSize badge badge-danger">Refilling</span>
                                                @elseif($data->v_work_status ==6)<span class="textSize badge badge-secondary">Refiled</span>
                                                @elseif($data->v_work_status ==7)<span class="textSize badge badge-warning">Hold</span>
                                                @elseif($data->v_work_status ==8)<span class="textSize badge badge-danger">Reject</span>
                                                @elseif($data->v_work_status ==9)<span class="textSize badge badge-primary">Update</span>
                                                @else<span class="badge">N/A</span>
                                                @endif

                                            </td>
                                            <td>@if($data->file != null)<a href="{{asset('upload/orderFile/'.$data->file)}}" download>{{$data->file}}</a>@else No File @endif</td>
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-info">Action</button>
                                                    <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                        data-toggle="dropdown">
                                                        <span class="sr-only">Toggle Dropdown</span>
                                                    </button>
                                                    <div class="dropdown-menu dropdown-content" role="menu">
                                                        @if(Auth::user()->role == 4 || Auth::user()->role == 6 )
                                                        <a class="dropdown-item"  href="{{url('accept-order-v-'.$data->id)}}" ><i
                                                        class="fas fa-check" style="padding-right:10px;"></i> Accept</a>

                                                        <a class="dropdown-item" href="{{url('decline-order-v-'.$data->id)}}"><i class="fas fa-times-circle"
                                                                style="padding-right:10px; "></i> Decline</a>


                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>

    @else
        @include('admin.404')
    @endif
@endsection

