<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>

@extends('admin.masterBlade')

@section('title')
Work
@endsection
@section('content')

<section class="content">
    <div class="container-fluid">

        <div class="row" style="margin-top:10px;">

            <div class="col-md-12">
                <div class="card bg-gradient-success">
                    <div class="card-header border-0 ui-sortable-handle" style="cursor: move;">
                        <h3 class="card-title">
                            Order Details
                        </h3>
                        <!-- tools card -->
                        <div class="card-tools">
                            <button type="button" class="btn btn-success btn-sm" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                        <!-- /. tools -->
                    </div>
                    <!-- /.card-header -->

                    <div class="card-body pt-0" style="display: block;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Assign Order ID : <b>{{$assign->unique_id}}</b></h2>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            <h2 class="card-title text-dark">App Link: </h2>
                                            <!-- /.col -->
                                            <div class="col-md-5">
                                                <a href="{{$Orders->apps_link}}"
                                                    target="_blank">Click Me</a>
                                            </div>
                                            <!-- /.col -->
                                            <h2 class="card-title text-dark">File: </h2>
                                            <!-- /.col -->
                                            <div class="col-md-5">
                                                <a href="{{asset('upload/orderFile/'.$Orders->file)}}" download>Download Me</a>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                    <div class="card-footer bg-light p-0" style="border-radius: 0.35rem;">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Order Date
                                                            <span class="float-right ">
                                                                <b>{{$assign->created_date}}</b></span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Dalivary Date
                                                            <span class="float-right text-danger">
                                                                <b>{{$assign->target_date}}</b></span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Speed Per day
                                                            <span class="float-right">
                                                                <b>{{$Orders->perday}}</b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            KeyWord
                                                            <span class="float-right">
                                                                <b> {{$Orders->key_word}} </b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Service Type
                                                            <span class="float-right">
                                                                <b>{{$Orders->service->name}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Platfrom
                                                            <span class="float-right">
                                                                <b>{{$Orders->platform}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            GEO
                                                            <span class="float-right">
                                                                <b>{{$Orders->geo}}</b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Start Point
                                                            <span class="float-right">
                                                                <b>{{$assign->start_point}}</b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>

                                        </div>

                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->

                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title text-dark">Work Status</h3>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <input type="hidden" name="assigned_id" id="assigned_id" value="{{$assign->id}}">
                                        <div class="row" id="changeStatus">
                                            <h6 class="card-title text-dark">Status :</h6>
                                            <div class="col-md-10">
                                                <div class="form-group">

                                                        @if ($assign->work_status == 10 || $assign->work_status == 7 || $assign->work_status == 11)
                                                            <select id="inputStatus" disabled class="form-control custom-select">
                                                        @else
                                                            <select id="inputStatus"  class="form-control custom-select">
                                                        @endif
                                                        <option disabled="" selected value="">Select Status</option>
                                                        <option value="1" {{($assign->work_status ==1)?'selected':''}}>Pending</option>
                                                        <option value="3" {{($assign->work_status ==3)?'selected':''}}>Work
                                                            in Progress</option>
                                                        <option value="7" {{($assign->work_status ==7)?'selected':''}}>On
                                                            Hold</option>
                                                        <option disabled title="You Can't Select This" value="6" {{($assign->work_status ==6)?'selected':''}}>
                                                            Refiled</option>
                                                        <option disabled title="You Can't Select This" value="5" {{($assign->work_status ==5)?'selected':''}}>
                                                            Refilling</option>
                                                        <option disabled title="You Can't Select This" value="4" {{($assign->work_status ==4)?'selected':''}}>
                                                            Finished</option>
                                                        <option disabled title="You Can't Select This" value="2" {{($assign->work_status ==2)?'selected':''}}>
                                                            Accept</option>
                                                        <option disabled title="You Can't Select This" value="9" {{($assign->work_status ==10)?'selected':''}}>Completed</option>

                                                        <option disabled title="You Can't Select This" value="11" {{($assign->work_status == 11 )?'selected':''}}>
                                                            Canceled</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                    @php
                                        if($total > 0){
                                            $pStatus = ($total/$assign->total_quantity)*100;
                                        }else{
                                            $pStatus = 0;
                                        }
                                        $getTotal = App\Models\WorksDetails::whereIn('status',[1,2,3])->where('assign_id',$assign->id)->where('posting_status',1)->count();
                                        $postingStatus = ($getTotal/$assign->total_quantity)*100;
                                    @endphp
                                    <div class="card-footer bg-light pb-1" style="border-radius: 0.35rem; margin-top: -28px;">
                                        <div class="col-md-12">
                                            <ul class="nav nav-pills flex-column">
                                                <li class="nav-item">
                                                    <a class="nav-link">Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar"
                                                                    aria-valuenow="{{$pStatus}}" aria-valuemin="0"
                                                                    aria-valuemax="100" style="width: {{$pStatus}}%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                {{number_format($pStatus)}}% Completed
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            {{$total}}/{{$assign->total_quantity}}
                                                        </h6>
                                                    </a>

                                                    @if($Orders->service_type_id == 1 || $Orders->service_type_id == 2)
                                                    <a class="nav-link">Posting Status Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar"
                                                                    aria-valuenow="{{$postingStatus}}" aria-valuemin="0"
                                                                    aria-valuemax="100" style="width: {{$postingStatus}}%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                {{number_format($postingStatus)}}% Completed
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            {{$getTotal}}/{{$assign->total_quantity}}
                                                        </h6>
                                                    </a>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Reason For Refilling</h2>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            @if ($Orders->reason != null && $assign->work_status ==5)
                                            <div class="col-md-12" style="overflow-y:scroll; height:146px; background:white">
                                                <h2 class="card-title text-dark">{{$Orders->reason}}</h2>
                                            </div>
                                            <!-- /.col -->
                                            @else
                                            <div class="col-md-12" style="height:146px; background:white">

                                            </div>
                                            @endif
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                </div>
                                <!-- /.card -->
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:10px;">
                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Works Details List
                            @if ($assign->work_status != 10 && $assign->work_status != 7 && $assign->work_status != 11)
                                @if ($total_avail >= $assign->total_quantity)
                                    <a href="#" @disabled(true) title="" id="complete" title="Already Completed The Work !!">
                                        <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                    </a>
                                @else

                                        @if ( $Orders->service_type_id == 3)
                                            <a href="#" title="" data-toggle="modal" data-target="#modal-install">
                                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                            </a>
                                        @else

                                        <a href="#" title="" data-toggle="modal" data-target="#modal-default">
                                            <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                        </a>
                                        @endif
                                        <a href="#" title="" data-toggle="modal"  data-target="#modal-default4">
                                            <i class="fas fa-upload" title="Upload Exel File" style="float: right; font-size:28px; padding-right:10px;"></i>
                                        </a>

                                @endif
                            @endif
                            <a href="{{route('inProgress-order-v')}}">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        @if( $Orders->service_type_id !=3)
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Work U_Id</th>
                                    <th width="25%">Review Text</th>
                                    <th>Title</th>
                                    <th>Rating</th>
                                    <th>User Name</th>
                                    <th>Posting Status</th>
                                    <th>Live Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="#" target="_blank">{{$data->work_details_u_id}}</a></td>
                                    <td>{{$data->reiew_discription}}</td>
                                    <td>{{$data->title}}</td>
                                    <td>
                                        @for ($i=0;$i<$data->ratting;$i++)
                                            <i class="fa fa-star text-warning"></i>
                                            @endfor
                                        @for ($i=0;$i<5-$data->ratting;$i++)
                                            <i class="far fa-star text-gray"></i>
                                        @endfor
                                         <p hidden>{{$data->ratting}}</p>
                                    </td>
                                    <td>@if($data->user_name != null){{$data->user_name}}@else N/A @endif</td>
                                    <!-- <td><a href="{{$data->link}}" target="_blank">Click Me</a></td> -->

                                    <!-- Posting Status -->
                                    <td>
                                        <div id="{{'viewPostingStatus'.$data->id}}" ondblclick="getOpen({{$data->id}})"
                                                title="Double Click For Update">
                                                @if($data->posting_status == 1)<span
                                                    class="textSize badge badge-success"> Posted </span>

                                                @elseif($data->posting_status ==2)<span
                                                    class="textSize badge badge-danger">Missed</span>

                                                @else<span class="badge">N/A</span>
                                                @endif
                                            </div>
                                            <div id="{{'updatePostingStatus'.$data->id}}" class="col-md-12" hidden>
                                                <div class="form-group workStatus">
                                                    @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11)
                                                    <select disabled class="form-control custom-select">
                                                        @else
                                                        <select id="workStatus" onchange="postingStatus(this)"
                                                            class="form-control custom-select">
                                                            @endif
                                                            <option value="" disabled selected>Select One</option>
                                                            <option value="1"
                                                                {{($data->posting_status ==1)?'selected':''}}>
                                                                <span class="textSize badge badge-success">Posted</span>
                                                            </option>
                                                            <option value="2"
                                                                {{($data->posting_status ==2)?'selected':''}}>
                                                                <span class="textSize badge badge-info"> Missed </span>
                                                            </option>

                                                            <input type="hidden" id="workId" value="{{$data->id}}">

                                                        </select>
                                                </div>
                                            </div>
                                    </td>
                                    <td>@if($data->created_date != null){{date('m/d/Y', strtotime($data->created_date))}}@else N/A @endif</td>
                                    <td>
                                        @if($data->work_details_status ==1)<span
                                            class="textSize badge badge-info">Alive</span>
                                        @elseif($data->work_details_status ==2)<span
                                            class="textSize badge badge-success">Alive Ok</span>
                                        @elseif($data->work_details_status ==3)<span
                                            class="textSize badge badge-danger">Duplicate</span>
                                        @elseif($data->work_details_status ==4)<span
                                            class="textSize badge badge-warning ">Dropped</span>
                                        @elseif($data->work_details_status ==5)<span
                                            class="textSize badge badge-danger">Wrong Text</span>
                                        @else<span class="badge">N/A</span>
                                        @endif

                                    </td>
                                    <td class="py-0 align-middle text-center">

                                        @if ($data->work_details_status ==2 || ($assign->work_status == 10 || $assign->work_status == 7 || $assign->work_status == 11))
                                            <div class="btn-group btn-group-sm">
                                                <span class="btn btn-info">N/A</span>
                                            </div>
                                        @else
                                            <div class="btn-group btn-group-sm" disabled>

                                                <a class="btn btn-info"  data-toggle="modal"
                                                data-target="#modal-default2" onclick="getValue({{$data->id}})" ><i class="fas fa-edit"></i></a>

                                                <a href="{{url('delete-work-details-'.$data->id)}}" id="delete"
                                                    class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @else
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Work U_Id</th>
                                    <th>Install Date</th>
                                    <th>Keyword</th>
                                    <th>Country</th>
                                    <th>Country Code</th>
                                    <th>osVersion</th>
                                    <th>IDFA</th>
                                    <th>IP</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td  class="py-0 align-middle text-center">{{$key+1}}</td>
                                    <td  class="py-0 align-middle text-center"><a href="#" target="_blank">{{$data->work_details_u_id}}</a></td>
                                    <td  class="py-0 align-middle text-center">{{date('m/d/Y', strtotime($data->install_date))}}</td>
                                    <td  class="py-0 align-middle text-center">{{$data->keyword}}</td>
                                    <td  class="py-0 align-middle text-center">{{$data->country}}</td>
                                    <td  class="py-0 align-middle text-center">{{$data->country_code}}</td>
                                    <td  class="py-0 align-middle text-center">{{$data->os_version}}</td>
                                    <td  class="py-0 align-middle text-center">{{$data->idfa}}</td>
                                    <td  class="py-0 align-middle text-center">{{$data->ip}}</td>

                                    <td>
                                        @if($data->work_details_status ==1)<span
                                            class="textSize badge badge-info">Alive</span>
                                        @elseif($data->work_details_status ==2)<span
                                            class="textSize badge badge-success">Alive Ok</span>
                                        @elseif($data->work_details_status ==3)<span
                                            class="textSize badge badge-danger">Duplicate</span>
                                        @elseif($data->work_details_status ==4)<span
                                            class="textSize badge badge-warning ">Dropped</span>
                                        @elseif($data->work_details_status ==5)<span
                                            class="textSize badge badge-danger">Wrong Text</span>
                                        @else<span class="badge">N/A</span>
                                        @endif

                                    </td>
                                    <td class="py-0 align-middle text-center">
                                        @if ($data->work_details_status ==2 || $assign->work_status == 10 || $assign->work_status == 7 || $assign->work_status == 11)
                                            <div class="btn-group btn-group-sm">
                                                <span class="btn btn-info">N/A</span>
                                            </div>
                                        @else
                                            <div class="btn-group btn-group-sm" disabled>

                                                <a class="btn btn-info"  data-toggle="modal"
                                                data-target="#modal-default3" onclick="getValue({{$data->id}})" ><i class="fas fa-edit"></i></a>

                                                <a href="{{url('delete-work-details-'.$data->id)}}" id="delete"
                                                    class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @endif
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<!-------add work without Install------------->
<div class="modal fade" id="modal-default">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="newOrderAdd" action="{{url('store-work-details-v')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="vandor_id" id="vandor_id" value="{{$assign->ven_Emp_id}}">
                            <input type="hidden" name="order_id" id="order_id" value="{{$assign->order_id}}">
                            <input type="hidden" name="assign_id" id="assign_id" value="{{$assign->id}}">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Review Text<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <textarea type="number" name="reiew_discription"
                                                        id="reiew_discription" class="form-control"
                                                        required=""></textarea>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Rating <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" min="1" max="5" name="ratting" id="ratting"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Work Title <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" step="title" name="title" id="title"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>User Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="user_name" id="user_name" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Posting Status <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="posting_status" class="form-control custom-select">
                                                        <option value="" disabled selected>Select One</option>
                                                            <option value="1">
                                                                <span class="textSize badge badge-success">Posted</span>
                                                            </option>
                                                            <option value="2">
                                                                <span class="textSize badge badge-info"> Missed </span>
                                                            </option>
                                                        </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!--------------add work Install------------->
<div class="modal fade" id="modal-install">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="newOrderAdd" action="{{url('store-work-details-install-v')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="vandor_id" id="vandor_id2" value="{{$assign->ven_Emp_id}}">
                            <input type="hidden" name="order_id" id="order_id2" value="{{$assign->order_id}}">
                            <input type="hidden" name="assign_id" id="assign_id2" value="{{$assign->id}}">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Install date (UTC) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" name="date"
                                                        id="date" class="form-control"
                                                        required="" max={{ $today }}>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Keyword<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="keyword"
                                                        id="keyword" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>osVersion <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="os" id="os" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country <span class="text-danger">*</span></h5>
                                                <select class="col-md-12 form-control select2bs4" id="country" name="country" >
                                                    <option id="clientName" selected="" >Select Clients</option>

                                                </select>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country Code <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="c_code"
                                                        id="c_code" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>IP <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="ip" id="ip" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>IDFA <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="idfa" id="idfa" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!--------------Edit work Install------------->
<div class="modal fade" id="modal-default2">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('update-work-details-v')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="vandor_id" id="vandor_id1">
                            <input type="hidden" name="order_id" id="order_id1" >
                            <input type="hidden" name="assign_id" id="assign_id1">
                            <input type="hidden" name="work_id" id="work_id1">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Review Text<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <textarea type="number" name="reiew_discription"
                                                        id="reiew_discription1" class="form-control"
                                                        required=""></textarea>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Ratting <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" min="1" max="5" name="ratting" id="ratting1"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Work Title <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" step="title" name="title" id="title1"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>User Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="user_name" id="user_name1" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Posting Status <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="posting_status" id="posting_status1" class="form-control custom-select">
                                                        <option value="" disabled selected>Select One</option>
                                                        <option value="1">
                                                            <span class="textSize badge badge-success">Posted</span>
                                                        </option>
                                                        <option value="2">
                                                            <span class="textSize badge badge-info"> Missed </span>
                                                        </option>
                                                    </select>
                                                </div>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!--------------Edit work Install------------->
<div class="modal fade" id="modal-default3">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('update-work-details-v')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="vandor_id" id="vandor_id5">
                            <input type="hidden" name="order_id" id="order_id5" >
                            <input type="hidden" name="assign_id" id="assign_id5">
                            <input type="hidden" name="work_id" id="work_id5">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Install date (UTC) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" name="date"
                                                        id="date" class="form-control"
                                                        required="" max={{ $today }}>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Keyword<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="keyword"
                                                        id="keyword5" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>osVersion <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="os" id="os5" class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="country"
                                                        id="country5" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country Code <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="c_code"
                                                        id="c_code5" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>IP <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="ip" id="ip5" class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>IDFA <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="idfa" id="idfa5" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div><!------End Row---------->
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-------Upload File------------->
<div class="modal fade" id="modal-default4">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Upload File</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('file-import')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="vandor_id" id="vandor_id" value="{{$assign->ven_Emp_id}}">
                            <input type="hidden" name="order_id" id="order_id" value="{{$assign->order_id}}">
                            <input type="hidden" name="assign_id" id="assign_id" value="{{$assign->id}}">
                            <input type="hidden" name="service_type_id" id="service_type_id" value="{{$Orders->service_type_id}}">


                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Add File<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="file" name="file"
                                                        id="file" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<script type="text/javascript">
    $("#inputStatus").on("on change", function () {

        var value = $('#inputStatus').val();
        var id = $('#assigned_id').val();

        // console.log("Here");

        if (id != '') {
            $.ajax({
                url: "updateStatus",
                method: "GET",
                data: {
                    id: id,
                    value: value,
                },
                dataType: "JSON",
                success: function (data) {
                    toastr.success("Status Updated");
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }

    });

</script>

<script>
    function getValue(r) {

        $("#id").val(r);
        var id = r;

        if (id != '') {
            $.ajax({
                url: "editWork",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data) {

                    if(data.service_type_id == 3)
                    {
                        $("#vandor_id5").val(data.vandor_id);
                        $("#order_id5").val(data.order_id);
                        $("#assign_id5").val(data.assign_id);
                        $("#work_id5").val(data.id);

                        $("#date5").val(data.install_date);
                        $("#keyword5").val(data.keyword);
                        $("#os5").val(data.os_version);
                        $("#country5").val(data.country);
                        $("#c_code5").val(data.country_code);
                        $("#ip5").val(data.ip);
                        $("#idfa5").val(data.idfa);
                    }else{
                        var total = parseInt(data.available) + parseInt(data.total_quantity);
                        $("#vandor_id1").val(data.vandor_id);
                        $("#order_id1").val(data.order_id);
                        $("#assign_id1").val(data.assign_id);
                        $("#work_id1").val(data.id);
                        $("#reiew_discription1").val(data.reiew_discription);
                        $("#ratting1").val(data.ratting);
                        $("#title1").val(data.title);
                        $("#posting_status1").val(data.posting_status);
                        $("#user_name1").val(data.user_name);
                    }

                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>

<script>
    function getOpen(r) {
        $('#updatePostingStatus' + r).removeAttr('hidden');
        $('#viewPostingStatus' + r).attr('hidden', '');
    }

    function postingStatus(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var posting_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();


        if (id != '') {
            $.ajax({
                url: "updatePostingStatus",
                method: "GET",
                data: {
                    id: id,
                    posting_status: posting_status,
                },
                dataType: "JSON",
                success: function (data) {

                    toastr.success(" Status Update ");

                    setTimeout( function(){
                        window.location.reload(true);
                    }  , 1000 );

                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>

@endsection
