<?php

use App\Mail\MyTestEmail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PermanentDelete;
use App\Http\Controllers\RestoreController;
use App\Http\Controllers\FootPrintController;
use App\Http\Controllers\ResetPasswordController;
use App\Http\Controllers\admin\AdminOrderController;
use App\Http\Controllers\admin\ManageUserController;

use App\Http\Controllers\admin\AdminProfileController;
use App\Http\Controllers\admin\ManageClientController;
use App\Http\Controllers\admin\ManageVendorController;
use App\Http\Controllers\client\ClientOrderController;
use App\Http\Controllers\vendor\VendorOrderController;
use App\Http\Controllers\admin\AssignForTextController;
use App\Http\Controllers\dashboard\DashboardController;
use App\Http\Controllers\admin\ManageEmployeeController;
use App\Http\Controllers\client\ClientProfileController;
use App\Http\Controllers\vendor\VendorProfileController;
use App\Http\Controllers\configuration\CompanyController;
use App\Http\Controllers\configuration\SidebarController;
use App\Http\Controllers\supervisor\SupervisorController;
use App\Http\Controllers\configuration\ManageMenuController;
use App\Http\Controllers\configuration\ManageRoleController;
use App\Http\Controllers\employee\EmployeeProfileController;
use App\Http\Controllers\admin\systemConfig\ServiceController;
use App\Http\Controllers\admin\systemConfig\ExpenseTypeController;
use App\Http\Controllers\accounts\vendor\PaymentReceivedController;
use App\Http\Controllers\admin\systemConfig\PaymentMethodController;
use App\Http\Controllers\admin\systemConfig\GeneralExpenseController;
use App\Http\Controllers\accounts\client\ClientRefundRequestController;
use App\Http\Controllers\admin\systemConfig\SubscriptionTypeController;
use App\Http\Controllers\accounts\administration\ManageRefundController;
use App\Http\Controllers\accounts\administration\SubscriptionController;
use App\Http\Controllers\admin\systemConfig\ManageSystemConfigController;
use App\Http\Controllers\accounts\administration\AdministrationController;
use App\Http\Controllers\accounts\administration\EmployeeSalaryController;
use App\Http\Controllers\accounts\administration\withdraw\WithdrawController;
use App\Http\Controllers\accounts\administration\SubscriptionPaymentController;
use App\Http\Controllers\accounts\administration\budgetReceived\SpendMoneyController;
use App\Http\Controllers\accounts\administration\budgetReceived\BudgetReceivedController;
use App\Http\Controllers\accounts\vendor\VendorBudgetReceiveController;
use App\Http\Controllers\accounts\client\PayController;
use App\Http\Controllers\admin\ReportController;
use App\Http\Controllers\client\ClientAccountsController;
use App\Http\Controllers\websites\BlogController;
use App\Http\Controllers\websites\ClientLogoController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {

    return view('auth.login');
});


Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/dashboard',[DashboardController::class,'index'])->name('dashboard');


//***************************************************************************************************************//
//------------------------------------=== Admin section ===-----------------------------------------------------//
//***************************************************************************************************************//

//-----------------==== Admin Profile ====------------------------------//

Route::get('profile',[AdminProfileController::class,'index'])->name('profile');
Route::post('update-profile-{id}',[AdminProfileController::class,'update']);
Route::post('update-password-{id}',[AdminProfileController::class,'updatePassword']);
Route::post('users-update-password',[ResetPasswordController::class,'update']);

    //--------------------==== Manage Users ====------------------------------//
  Route::get('manage-users',[ManageUserController::class,'index'])->name('manageUser');
  Route::get('view-active-users',[ManageUserController::class,'viewActive'])->name('viewActive');
  Route::get('findUsers',[ManageUserController::class,'findUsers']);
  Route::get('editUserprofile-{id}',[ManageUserController::class,'editUser']);
  Route::post('update-user-profile-{id}',[ManageUserController::class,'updateUser']);
  Route::get('active-user-{id}',[ManageUserController::class,'ActiveUser']);

  //   store is dark
  Route::get('is-dark-mode',[ManageUserController::class,'storeIsDark']);

    //--------------------==== Manage Client ====------------------------------//
  Route::get('view-active-clients',[ManageClientController::class,'active'])->name('view-active-clients');
  Route::get('view-inative-clients',[ManageClientController::class,'inactive'])->name('view-inactive-clients');
  Route::get('view-all-clients',[ManageClientController::class,'all'])->name('view-all-clients');
              //Add Client
  Route::get('add-new-client',[ManageClientController::class,'addClient']);
  Route::post('store-client-data',[ManageClientController::class,'store']);
  Route::get('reset-client-password-{id}',[ManageClientController::class,'resetPassword']);
              //Client Profile
  Route::get('view-client-profile-{id}',[ManageClientController::class,'viewClientProfile']);
  Route::get('edit-client-profile-{id}',[ManageClientController::class,'editClient']);
  Route::post('update-client-profile-{id}',[ManageClientController::class,'updateClient']);
             //Manage Client
  Route::get('inactive-client-{id}',[ManageClientController::class,'InactiveClient']);
  Route::get('active-client-{id}',[ManageClientController::class,'ActiveClient']);
  Route::get('delete-client-{id}',[ManageClientController::class,'DistroyClient']);

  //Manage Client Account
  Route::get('client-order-pay-accept-{id}',[ClientAccountsController::class,'clientOrderPayAccept']);
  Route::get('client-order-pay-declined-{id}',[ClientAccountsController::class,'clientOrderPayDeclined']);
 //---------------------====  End Client  ====------------------------------//

 //--------------------==== Manage Vendor ====------------------------------//
  Route::get('view-active-vendor',[ManageVendorController::class,'active'])->name('view-active-vendor');
  Route::get('view-inative-vendor',[ManageVendorController::class,'inactive'])->name('view-inactive-vendor');
  Route::get('view-all-vendor',[ManageVendorController::class,'all'])->name('view-all-vendor');
              //Add Vendor
  Route::get('add-new-vendor',[ManageVendorController::class,'addVendor']);
  Route::post('store-vendor-data',[ManageVendorController::class,'store']);
              //Client Vendor

  Route::get('edit-vendor-profile-{id}',[ManageVendorController::class,'editVendor']);
  Route::post('update-vendor-profile-{id}',[ManageVendorController::class,'updateVendor']);
             //Manage Vendor
  Route::get('inactive-vendor-{id}',[ManageVendorController::class,'InactiveVendor']);
  Route::get('active-vendor-{id}',[ManageVendorController::class,'ActiveVendor']);
  Route::get('delete-vendor-{id}',[ManageVendorController::class,'DistroyVendor']);
   //---------------------====  End Vendor  ====------------------------------//

   //--------------------==== Manage Employee ====------------------------------//
   Route::get('view-active-employee',[ManageEmployeeController::class,'active'])->name('view-active-employee');
   Route::get('view-inative-employee',[ManageEmployeeController::class,'inactive'])->name('view-inactive-employee');
   Route::get('view-all-employee',[ManageEmployeeController::class,'all'])->name('view-all-employee');
               //Add Employee
   Route::get('add-new-employee',[ManageEmployeeController::class,'addEmployee']);
   Route::post('store-employee-data',[ManageEmployeeController::class,'store']);
               //Client Employee
   Route::get('edit-employee-profile-{id}',[ManageEmployeeController::class,'editEmployee']);
   Route::post('update-employee-profile-{id}',[ManageEmployeeController::class,'updateEmployee']);
              //Manage Employee
   Route::get('inactive-employee-{id}',[ManageEmployeeController::class,'InactiveEmployee']);
   Route::get('active-employee-{id}',[ManageEmployeeController::class,'ActiveEmployee']);
   Route::get('delete-employee-{id}',[ManageEmployeeController::class,'DistroyEmployee']);
    //---------------------====  End Employee  ====------------------------------//

    //--------------------==== Manage System Config ====------------------------------//
    Route::get('view-system-config',[ManageSystemConfigController::class,'index'])->name('view-system');
           //Service Type
    Route::get('service-type-view',[ServiceController::class,'index'])->name('view-service-type');
    Route::post('store-service-type',[ServiceController::class,'store']);
    Route::post('update-service-type',[ServiceController::class,'update']);
    Route::get('findData',[ServiceController::class, 'findService']);
    Route::get('delete-service-{id}',[ServiceController::class,'destroy']);
           //Expense Type
    Route::get('expense-type',[ExpenseTypeController::class,'index'])->name('view-expense');
    Route::post('store-expense-type',[ExpenseTypeController::class,'store']);
    Route::post('update-expense-type',[ExpenseTypeController::class,'update']);
    Route::get('findExpense',[ExpenseTypeController::class, 'findExpense']);
    Route::get('delete-expense-{id}',[ExpenseTypeController::class,'destroy']);
           //General Expense
    Route::get('general-expense',[GeneralExpenseController::class,'index'])->name('general-expense');
    Route::post('store-general-expense',[GeneralExpenseController::class,'store']);
    Route::get('edit-general-expense-{id}',[GeneralExpenseController::class,'edit']);
    Route::post('update-general-expense-{id}',[GeneralExpenseController::class,'update']);
    Route::get('findGenExpense',[GeneralExpenseController::class, 'findGenExpense']);
    Route::get('delete-general-expense-{id}',[GeneralExpenseController::class,'destroy']);

    //---------------------====  End System Config  ====------------------------------//

    //--------------------==== Manage Orders  ====------------------------------//
    
    Route::get('/test-mail', function() {
        $name = "Funny Coder";
    
        Mail::to('dev.kaamrul@gmail.com')->send(new MyTestEmail($name));

        return 'Funny Coder';
    });
    
    
    Route::get('make-new-order',[AdminOrderController::class,'newOrder']);
    Route::post('store-admin-order',[AdminOrderController::class,'storeNewOrder']);
    Route::get('view-pending-order',[AdminOrderController::class,'index'])->name('view-pending-order');
    Route::get('accept-pending-order-{order}',[AdminOrderController::class,'accept']);
    Route::get('dicline-pending-order-{id}',[AdminOrderController::class,'decline']);
    Route::get('view-orders',[AdminOrderController::class,'viewOrders'])->name('view-orders');
    Route::get('findOrderDetailsData',[AdminOrderController::class,'findOrderDetails']);
    Route::post('assign-order',[AdminOrderController::class,'assignOrder']);
    Route::get('view-assign-orders',[AdminOrderController::class,'ViewAssignOrder'])->name('view-assign-orders');
    Route::get('view-complete-assign-orders',[AdminOrderController::class,'ViewComAssignOrder']);
    Route::get('editAssignOrders',[AdminOrderController::class,'editAssignOrders']);
    Route::post('edit-assign-order',[AdminOrderController::class,'edit']);
    Route::get('hold-assign-order-{id}',[AdminOrderController::class,'hold']);
    Route::get('resume-assign-order-{id}',[AdminOrderController::class,'resume']);
    Route::get('completed-orders',[AdminOrderController::class,'ViewCompletedOrder']);
    Route::get('findUserTypeToAssign',[AdminOrderController::class,'findUserTypeToAssign']);
    Route::get('view-decline-order',[AdminOrderController::class,'declineOrder'])->name('view-decline-order');
    Route::get('canceled-order',[AdminOrderController::class,'canceleOrder'])->name('view-canceled-order');
    Route::get('canceled-assigned-order',[AdminOrderController::class,'canceledAssignedOrder'])->name('view-canceled-assigned-order');

                                    //CheckWork On Order
    Route::get('check-work-onOrder-{id}',[AdminOrderController::class,'CheckWork']);

                                    //Assign  Order for Check
    Route::post('assign-order-check',[AdminOrderController::class,'assignToCheckWork']);
    Route::get('findWorkCheck',[AdminOrderController::class,'findWorkCheck']);

                                     //Check Order
    Route::get('check-work-details-{id}',[AdminOrderController::class,'CheckWorkDetails']);
    Route::get('updateWorkDetailsStatus',[AdminOrderController::class,'updateWorkDetailsId']);
    Route::get('updateAssignWorStatus',[AdminOrderController::class,'updateAssignWorStatus']);
    Route::get('updateOrderStatus',[AdminOrderController::class,'updateOrderStatus']);
    Route::get('updateWorkDetailsDate',[AdminOrderController::class,'updateWorkDetailsDate']);


                                    //Assign for Text
    Route::post('assign-order-for-text-add',[AssignForTextController::class,'assign']);
    Route::post('upload-order-text',[AssignForTextController::class,'upload']);

                                        //Update userName
    Route::get('updateUserName',[AdminOrderController::class,'updateUserName']);

    Route::get('view-hold-order-a',[AdminOrderController::class,'holdOrder']);
    Route::get('view-hold-assign-order',[AdminOrderController::class,'holdAssignOrder']);



    //Service Type
    // Route::get('service-type',[AdminOrderController::class,'index'])->name('view-service');
    // Route::post('store-service-type',[AdminOrderController::class,'store']);
    // Route::post('update-service-type',[AdminOrderController::class,'update']);
    // Route::get('findData',[AdminOrderController::class, 'findService']);
    // Route::get('delete-service-{id}',[AdminOrderController::class,'destroy']);


    //---------------------====  End Order  ====------------------------------//

    //-------------------------------==== FootPrint ====------------------------------//
     Route::get('view-foot-print',[FootPrintController::class,'index'])->name('view-foot-print');

     //*----------------**Permanent Delete**-----------------/*
    Route::get('permanent-delete-User-{fid}-{id}', [PermanentDelete::class, 'User']);
    Route::get('permanent-delete-Order-{fid}-{id}', [PermanentDelete::class, 'Order']);
    Route::get('permanent-delete-Assign-{fid}-{id}', [PermanentDelete::class, 'Assign']);
    Route::get('permanent-delete-WorksDetails-{fid}-{id}', [PermanentDelete::class, 'WorksDetails']);
    Route::get('permanent-delete-OrderSummary-{fid}-{id}', [PermanentDelete::class, 'OrderSummary']);
    Route::get('permanent-delete-Transection-{fid}-{id}', [PermanentDelete::class, 'Transection']);
    Route::get('permanent-delete-ServiceType-{fid}-{id}', [PermanentDelete::class, 'ServiceType']);
    Route::get('permanent-delete-RiskFund-{fid}-{id}', [PermanentDelete::class, 'RiskFund']);
    Route::get('permanent-delete-ExpenseType-{fid}-{id}', [PermanentDelete::class, 'ExpenseType']);
    Route::get('permanent-delete-Expense-{fid}-{id}', [PermanentDelete::class, 'Expense']);

    Route::get('permanent-delete-ClientRefundRequest-{fid}-{id}', [PermanentDelete::class, 'ClientRefundRequest']);
    Route::get('permanent-delete-BudgetReceived-{fid}-{id}', [PermanentDelete::class, 'BudgetReceived']);
    Route::get('permanent-delete-Withdraw-{fid}-{id}', [PermanentDelete::class, 'Withdraw']);
    Route::get('permanent-delete-SubscriptionPayment-{fid}-{id}', [PermanentDelete::class, 'SubscriptionPayment']);
    Route::get('permanent-delete-Subscription-{fid}-{id}', [PermanentDelete::class, 'Subscription']);
    Route::get('permanent-delete-EmployeeSalary-{fid}-{id}', [PermanentDelete::class, 'EmployeeSalary']);
    Route::get('permanent-delete-SubscriptionType-{fid}-{id}', [PermanentDelete::class, 'SubscriptionType']);
    Route::get('permanent-delete-PaymentMethods-{fid}-{id}', [PermanentDelete::class, 'PaymentMethods']);


    //-----------------**** Restore Data ****----------------------//
    Route::get('restore-User-{fid}-{id}', [RestoreController::class, 'User']);
    Route::get('restore-Order-{fid}-{id}', [RestoreController::class, 'Order']);
    Route::get('restore-Assign-{fid}-{id}', [RestoreController::class, 'Assign']);
    Route::get('restore-WorksDetails-{fid}-{id}', [RestoreController::class, 'WorksDetails']);
    Route::get('restore-OrderSummary-{fid}-{id}', [RestoreController::class, 'OrderSummary']);
    Route::get('restore-Transection-{fid}-{id}', [RestoreController::class, 'Transection']);
    Route::get('restore-ServiceType-{fid}-{id}', [RestoreController::class, 'ServiceType']);
    Route::get('restore-RiskFund-{fid}-{id}', [RestoreController::class, 'RiskFund']);
    Route::get('restore-ExpenseType-{fid}-{id}', [RestoreController::class, 'ExpenseType']);
    Route::get('restore-Expense-{fid}-{id}', [RestoreController::class, 'Expense']);


    Route::get('restore-ClientRefundRequest-{fid}-{id}', [RestoreController::class, 'ClientRefundRequest']);
    Route::get('restore-BudgetReceived-{fid}-{id}', [RestoreController::class, 'BudgetReceived']);
    Route::get('restore-Withdraw-{fid}-{id}', [RestoreController::class, 'Withdraw']);
    Route::get('restore-SubscriptionPayment-{fid}-{id}', [RestoreController::class, 'SubscriptionPayment']);
    Route::get('restore-Subscription-{fid}-{id}', [RestoreController::class, 'Subscription']);
    Route::get('restore-EmployeeSalary-{fid}-{id}', [RestoreController::class, 'EmployeeSalary']);
    Route::get('restore-SubscriptionType-{fid}-{id}', [RestoreController::class, 'SubscriptionType']);
    Route::get('restore-PaymentMethods-{fid}-{id}', [RestoreController::class, 'PaymentMethods']);

    //-----------------------====  End FootPrint  ====--------------------------------//

//********************************************* ==End Admin== ****************************************************//


//***************************************************************************************************************//
//                                               Client section
//***************************************************************************************************************//
    Route::get('client-order-list',[ClientOrderController::class,'orderList'])->name('orderList');
    Route::post('store-client-order',[ClientOrderController::class,'store']);
                                    //CheckWork On Order
    Route::get('check-work-onOrderC-{id}',[ClientOrderController::class,'CheckWork']);
    Route::get('check-work-onCompleteOrderC-{id}',[ClientOrderController::class,'CheckCompleteWork']);

    Route::get('updateWorkDetailsStatusC',[ClientOrderController::class,'updateWorkDetailsStatusC']);
    Route::get('updateOrderStatusC',[ClientOrderController::class,'updateOrderStatusClient']);

    Route::get('updateStatusOfOrder',[ClientOrderController::class,'updateStatusOfOrder']);

                                       //Edit Order
    Route::get('editOrder',[ClientOrderController::class,'editOrder']);
    Route::post('update-client-order',[ClientOrderController::class,'updateOrder']);
    Route::get('deleteFileFromOrder',[ClientOrderController::class,'deleteFileFromOrder']);

    Route::get('canceled-order-c',[ClientOrderController::class,'canceleOrder'])->name('view-canceled-order-c');

    //Client Accounts
    Route::get('client-partial-payment',[ClientAccountsController::class,'index']);
    Route::get('client-complete-order-payment',[ClientAccountsController::class,'completeOrders']);
    Route::get('client-cancel-order-payment',[ClientAccountsController::class,'cancleOrders']);
    Route::post('client-store-spend-money',[ClientAccountsController::class, 'store']);






//***************************************************************************************************************//
//                                              Client section End
//***************************************************************************************************************//


//***************************************************************************************************************//
//                                               Vendor section
//***************************************************************************************************************//
                                                //Pending Order
    Route::get('pending-order-v',[VendorOrderController::class,'pendingOrder'])->name('pending-order-v');
    Route::get('accept-order-v-{id}',[VendorOrderController::class,'AcceptOrder']);
    Route::get('order-list-v',[VendorOrderController::class,'OrderList']);
    Route::get('decline-order-v-{id}',[VendorOrderController::class,'DeclineOrder']);
    Route::get('view-hold-order-e',[VendorOrderController::class,'holdList']);
    Route::get('view-hold-order-v',[VendorOrderController::class,'holdList']);


                                                    //InProgress Order
    Route::get('In-progress-orders-v',[VendorOrderController::class,'InProgressOrder'])->name('inProgress-order-v');
    Route::get('work-details-{id}',[VendorOrderController::class,'WorkDetails']);
    Route::post('store-work-details-v',[VendorOrderController::class,'StoreWorkDetails']);
    Route::post('store-work-details-install-v',[VendorOrderController::class,'StoreWorkDetailsInstall']);
    Route::post('update-work-details-v',[VendorOrderController::class,'UpdateWorkDetails']);
    //Route::post('update-work-details-install-v',[VendorOrderController::class,'UpdateWorkDetails']);
    Route::get('delete-work-details-{id}',[VendorOrderController::class,'deleteWorkDetails']);

                                                    //Rejected Order
    Route::get('rejected-orders-v',[VendorOrderController::class,'RejectedOrders'])->name('rejected-orders-v');

                                                    //Rejected Order
    Route::get('completed-orders-v',[VendorOrderController::class,'CompleteOrders'])->name('completed-orders-v');

    Route::get('updateStatus',[VendorOrderController::class,'UpdateStatus']);
                                                    //Edit works
    Route::get('editWork',[VendorOrderController::class,'editWork']);

    Route::post('file-import', [VendorOrderController::class, 'fileImport'])->name('file-import');

    Route::get('updatePostingStatus',[VendorOrderController::class,'updatePostingStatus']);

    //Cancel Order
    Route::get('vendor-canceled-order',[VendorOrderController::class,'CancelOrders'])->name('vendor-canceled-order');


//***************************************************************************************************************//
//                                              Vendor section End
//***************************************************************************************************************//

//***************************************************************************************************************//
//                                               Supervisor section
//***************************************************************************************************************//

  Route::get('check-order',[SupervisorController::class,'index'])->name('check-order');
  Route::get('assign-for-text',[SupervisorController::class,'show']);
  Route::get('assign-for-text-e',[SupervisorController::class,'show']);
  Route::get('getValueFromOrder',[SupervisorController::class,'getValueFromOrder']);


//***************************************************************************************************************//
//                                              Supervisor section End
//***************************************************************************************************************//



// *********************************************************************************************************************
//                      Kamrul Route Start
// *********************************************************************************************************************

    // Dynamic Menu & User Access
    Route::group(['middleware' => ['auth']], function () {
        //user menus access
        Route::get('/user-access', [SidebarController::class, 'useraccess'])->name('user-access');
        Route::get('/admin-user-access', [SidebarController::class, 'adminUserAccess'])->name('admin-user-access');
        Route::get('/clients-user-access', [SidebarController::class, 'clientsUserAccess'])->name('clients-user-access');
        Route::get('/vendor-user-access', [SidebarController::class, 'vendorUserAccess'])->name('vendor-user-access');
        Route::get('/employee-user-access', [SidebarController::class, 'employeeUserAccess'])->name('employee-user-access');

        Route::post('/get_menu_list', [SidebarController::class, 'get_menu_list'])->name('get_menu_list');
        Route::post('/insert_menu_accessList', [SidebarController::class, 'insert_menu_accessList'])->name('insert_menu_accessList');
        Route::get('/adminMenu', [SidebarController::class, 'adminMenu'])->name('adminMenu');
        Route::post('/storeMenu', [SidebarController::class, 'storeMenu'])->name('storeMenu');

        // Manage User Role
        Route::get('/manage-user-role', [ManageRoleController::class, 'index']);
        Route::post('update-role', [ManageRoleController::class, 'update'])->name('update-role');

        // Manage Main Menu
        Route::get('/manage-menu', [ManageMenuController::class, 'index']);
        Route::post('update-menu', [ManageMenuController::class, 'update'])->name('update-menu');


        // Company Setup
        Route::get('/manage-company', [CompanyController::class, 'create'])->name('company-info');
        Route::post('updateCompanyInfos', [CompanyController::class, 'updateCompanyInfos'])->name('updateCompanyInfos');

        // Payment Methods
        Route::get('/payment-method', [PaymentMethodController::class, 'index'])->name('payment-method');
        Route::post('store-payment-method', [PaymentMethodController::class, 'store'])->name('store-payment-method');
        Route::post('update-payment-method', [PaymentMethodController::class, 'update'])->name('update-payment-method');
        Route::get('destroy-payment-method-{id}', [PaymentMethodController::class, 'destroy']);

        // Subscription Type
        Route::get('/subscription-type', [SubscriptionTypeController::class, 'index'])->name('subscription-type');
        Route::post('store-subscription-type', [SubscriptionTypeController::class, 'store'])->name('store-subscription-type');
        Route::post('update-subscription-type', [SubscriptionTypeController::class, 'update'])->name('update-subscription-type');
        Route::get('destroy-subscription-type-{id}', [SubscriptionTypeController::class, 'destroy']);
        
        
        // Blocked Keywords
        Route::get('/blocked-keywords', [ManageUserController::class, 'blockedKeywords'])->name('blocked-keywords');
        Route::post('/update-blocked-keywords', [ManageUserController::class, 'updateBlockedKeywords'])->name('update-blocked-keywords');
        Route::get('/delete-blocked-keywords-{id}', [ManageUserController::class, 'deleteBlockedKeyword']);


        // **************************************
        //    Administration Accounts Starts    *
        // **************************************
        Route::get('/pay-to', [AdministrationController::class, 'index'])->name('pay-to');

        // Employee Salary Controller
        Route::get('findEmployeeSalary',[EmployeeSalaryController::class, 'findEmployeeSalary']);
        Route::post('store-employee-salary', [EmployeeSalaryController::class, 'store']);
        Route::get('findEmployeeSalaryID',[EmployeeSalaryController::class, 'findEmployeeSalaryID']);
        Route::post('update-employee-salary', [EmployeeSalaryController::class, 'update'])->name('update-employee-salary');
        Route::get('destroy-employee-salary-{id}', [EmployeeSalaryController::class, 'destroy']);

        // Subscription Generate
        Route::post('store-subscription', [SubscriptionController::class, 'store']);
        Route::get('subscription-details-{id}',[SubscriptionController::class, 'details']);
        Route::get('findSubscriptionID',[SubscriptionController::class, 'findSubscriptionID']);
        Route::post('update-subscriptions', [SubscriptionController::class, 'update'])->name('update-subscriptions');
        Route::get('destroy-subscription-{id}', [SubscriptionController::class, 'destroy']);

        // Subscription Pay Now
        Route::post('subscriptions-pay-now',[SubscriptionPaymentController::class, 'store']);
        Route::get('findSubscriptionPaymentID',[SubscriptionPaymentController::class, 'findSubscriptionPaymentID']);
        Route::post('update-subscriptions-payments', [SubscriptionPaymentController::class, 'update'])->name('update-subscriptions-payments');
        Route::get('destroy-sub-paymment-{id}', [SubscriptionPaymentController::class, 'destroy']);

        // Withdraw
        Route::get('manage-withdraw',[WithdrawController::class, 'index']);
        Route::post('store-withdraw',[WithdrawController::class, 'store']);
        Route::get('findWithdrawID',[WithdrawController::class, 'findWithdrawID']);
        Route::post('update-withdraw',[WithdrawController::class, 'update'])->name('update-withdraw');
        Route::get('destroy-withdraw-{id}',[WithdrawController::class, 'destroy']);

        // budget-received
        Route::get('manage-budget-received',[BudgetReceivedController::class, 'index']);
        Route::post('store-budget-received',[BudgetReceivedController::class, 'store']);
        Route::get('findBudgtRecID',[BudgetReceivedController::class, 'findBudgtRecID']);
        Route::post('update-budget-received',[BudgetReceivedController::class, 'update'])->name('update-budget-received');
        Route::get('destroy-budget-received-{id}',[BudgetReceivedController::class, 'destroy']);
        Route::get('client-budget-received-accept-{id}',[BudgetReceivedController::class, 'clientBudgetReceiveAccept']);
        Route::get('client-budget-received-declined-{id}',[BudgetReceivedController::class, 'clientBudgetReceiveDeclined']);

         //Vendor budget-received
        Route::get('view-vendor-budget-receive',[BudgetReceivedController::class, 'vendorBudgetReceive']);
        Route::get('vendor-budget-received-accept-{id}',[BudgetReceivedController::class, 'vendorBudgetReceiveAccept']);
        Route::get('vendor-budget-received-declined-{id}',[BudgetReceivedController::class, 'vendorBudgetReceiveDeclined']);

        // vendor payment
        Route::get('findAssignOrder',[PaymentReceivedController::class,'findAssignOrder']);
        Route::get('findAssignDetails',[PaymentReceivedController::class,'findAssignDetails']);
        Route::get('findOrderDetails',[PaymentReceivedController::class,'findOrderDetails']);
        Route::get('getPaymentFormDetails',[PaymentReceivedController::class,'getPaymentFormDetails']);
        Route::post('store-vendor-payment',[PaymentReceivedController::class, 'store']);

        // **************************************
        //     Administration Accounts Ends     *
        // **************************************

        // **************************************
        //        Clients Profile Starts        *
        // **************************************
        Route::get('client-profile-{id}',[ClientProfileController::class,'index']);
        Route::get('client-payment',[PayController::class,'index']);
        Route::post('client-payment',[PayController::class,'store']);
        Route::get('spend-money-against-order',[ClientProfileController::class,'spendMoneyAgainstOrder']);

        // Clients Refund Request
        Route::get('clients-refund-request',[ClientRefundRequestController::class,'index']);
        Route::get('getOrderDetails',[ClientRefundRequestController::class,'getOrderDetails']);
        Route::get('getTotalWorks',[ClientRefundRequestController::class,'getTotalWorks']);
        Route::get('getTotalCost',[ClientRefundRequestController::class,'getTotalCost']);
        Route::get('getTotalRefundAmount',[ClientRefundRequestController::class,'getTotalRefundAmount']);
        Route::post('store-client-refund-request',[ClientRefundRequestController::class, 'store']);
        Route::get('destroy-clients-refund-request-{id}',[ClientRefundRequestController::class, 'destroy']);

        // Manage Refund From Admin
        Route::get('manage-refund',[ManageRefundController::class,'index']);
        Route::get('pay-clients-refund-request-{id}',[ManageRefundController::class, 'payClientsRefundRequest']);

        // spend money
        Route::get('spend-money-{id}',[SpendMoneyController::class, 'index']);
        Route::get('findClientsOrder',[SpendMoneyController::class, 'findClientsOrder']);
        Route::get('findClientsCurrentBalance',[SpendMoneyController::class, 'findClientsCurrentBalance']);
        Route::get('findCompleteWorksWhenHold',[SpendMoneyController::class, 'findCompleteWorksWhenHold']);
        Route::post('store-spend-money',[SpendMoneyController::class, 'store']);

        Route::get('order-payment-received',[SpendMoneyController::class, 'list']);


        // **************************************
        //          Clients Profile Ends        *
        // **************************************

        // **********************************************
        //        Vendor Profile/Accounts Starts        *
        // **********************************************
        Route::get('view-vendor-profile-{id}',[VendorProfileController::class,'index']);
        Route::get('vendor-received-payment',[DashboardController::class,'vendorReceivedPayment']);

        Route::get('view-employee-profile-{id}',[EmployeeProfileController::class,'index']);

        //Vendor budget-received
        Route::get('vendor-budget-received',[VendorBudgetReceiveController::class, 'index']);
        Route::post('vendor-store-budget-received',[VendorBudgetReceiveController::class, 'store']);
        Route::get('vendor-findBudgtRecID',[VendorBudgetReceiveController::class, 'findBudgtRecID']);
        Route::post('vendor-update-budget-received',[VendorBudgetReceiveController::class, 'update']);
        Route::get('vendor-destroy-budget-received-{id}',[VendorBudgetReceiveController::class, 'destroy']);


        // **********************************************
        //          Vendor Profile/Accounts Ends        *
        // **********************************************

    });

// *********************************************************************************************************************
//                      Kamrul Route End
// *********************************************************************************************************************


    //                  Further Development
    // ****************************************************

    // Client logo
    Route::get('manage-client-logo',[ClientLogoController::class,'index']);
    Route::post('store-client-logo',[ClientLogoController::class, 'store']);
    Route::get('findClientLogo',[ClientLogoController::class,'findClientLogo']);
    Route::post('update-client-logo',[ClientLogoController::class, 'update'])->name('update-client-logo');
    Route::get('destroy-client-logo-{clientLogo}',[ClientLogoController::class,'destroy']);

    // Manage blog
    Route::get('manage-blog',[BlogController::class,'index'])->name('blog.list');
    Route::post('store-blog',[BlogController::class, 'store'])->name('store.blog');
    Route::get('edit-blog-{blog}',[BlogController::class,'editBlog']);
    Route::post('update-blog',[BlogController::class, 'update'])->name('update.blog');
    Route::get('destroy-blog-{blog}',[BlogController::class,'destroy']);
    Route::get('details-blog-{blog}',[BlogController::class,'detailsBlog']);

    // Report Controller
    Route::get('order-report',[ReportController::class,'orderReport'])->name('orderReport');
    Route::post('search-order-report',[ReportController::class,'searchOrderReport'])->name('searchOrderReport');

});