<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
?>



<?php $__env->startSection('title'); ?>
    Blog List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if($findRole->url == $currentURL ): ?>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">
                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Blog List
                                <a href="#" title="" data-toggle="modal" data-target="#create-blog">
                                    <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Operator</th>
                                        <th>Title</th>
                                        <th>Image</th>
                                        <th>Image alt Name</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $blog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td>
                                            <?php if($data->created_by != null): ?>
                                                <?php echo e($data->operator->name); ?>

                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($data->title); ?></td>
                                        <td>
                                            <img class="profile-user-img img-fluid " 
                                            src="<?php echo e((!empty($data->image)) ? url('upload/blog/'.$data->image):url('upload/NoImage.png')); ?>" 
                                            alt="<?php echo e($data->image_alt_name ?? 'N/A'); ?>">
                                        </td>
                                        <td><?php echo e($data->image_alt_name ?? 'N/A'); ?></td>
                                        <td><?php echo e($data->created_date); ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                    data-toggle="dropdown">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu">
                                                    <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                                                        <a class="dropdown-item" href="<?php echo e(url('details-blog-'.$data->id)); ?>"><span
                                                            class="fa fa-eye" style="padding-right:10px;"></span> Details</a>
                                                        <a class="dropdown-item" href="<?php echo e(url('edit-blog-'.$data->id)); ?>"><span
                                                            class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                    <?php endif; ?>
                                                    <?php if(Auth::user()->role == 1): ?>
                                                        <a class="dropdown-item" id="delete" href="<?php echo e(url('destroy-blog-'.$data->id)); ?>"><span
                                                            class="fa fa-trash" style="padding-right:10px;"></span> Delete</a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <!-- /Add Blog Modal Start -->
    <div class="modal fade" id="create-blog">
        <?php echo $__env->make('admin.page.manageWebsites.blog.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!-- /Add Blog Modal End -->

    <?php else: ?>
        <?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/manageWebsites/blog/index.blade.php ENDPATH**/ ?>