<?php if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 ): ?>


<?php $__env->startSection('title'); ?>
Order List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Order List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Clients</th>
                                    <th>Unique Id</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Available Work</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                    <th>Comment</th>
                                    <th>File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <?php
                                      $flag = 1;
                                  ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td><a href="<?php echo e(url('client-profile-'.$data->order_creator_id)); ?>" target="_blank" ><?php echo e($data->client->name); ?></a></td>
                                    <td><a href="<?php echo e(url('check-work-onOrder-'.$data->id)); ?>" target="_blank" ><?php echo e($data->order_unique_id); ?></a></td>
                                    <td><a href="<?php echo e($data->apps_link); ?>" target="_blank" >Link</a></td>
                                    <td><?php echo e($data->platform); ?></td>
                                    <td><?php echo e($data->geo); ?></td>
                                    <td><?php echo e($data->service->name); ?></td>
                                    <td><?php echo e($data->target_date); ?></td>
                                    <td><?php echo e($data->total_quantity); ?></td>
                                    <td><?php echo e($data->available_quantity); ?></td>
                                    <td><?php echo e($data->service_cost); ?></td>
                                    <td><?php echo e($data->total_budget); ?></td>
                                    <td><?php echo e($data->perday); ?></td>
                                    <td><?php echo e($data->key_word); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $total; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($tData->o_id == $data->id): ?>
                                               <?php echo e($tData->total); ?>/<?php echo e($data->total_quantity); ?>

                                               <?php
                                                    $flag = 0;
                                               ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if( $flag == 1): ?>
                                           0/<?php echo e($data->total_quantity); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>

                                        <?php if($data->order_status ==1): ?><span class="textSize badge badge-warning">Pending</span>
                                        <?php elseif($data->order_status ==2): ?><span class="textSize badge badge-info">Accept</span>
                                        <?php elseif($data->order_status ==3): ?><span class="textSize badge badge-success">In Work</span>
                                        <?php elseif($data->order_status ==4): ?><span class="textSize badge badge-warning ">Finished</span>
                                        <?php elseif($data->order_status ==5): ?><span class="textSize badge badge-danger">Refilling</span>
                                        <?php elseif($data->order_status ==6): ?><span class="textSize badge badge-secondary">Refiled</span>
                                        <?php elseif($data->order_status ==7): ?><span class="textSize badge badge-primary">Hold</span>
                                        <?php elseif($data->order_status ==8): ?><span class="textSize badge badge-danger">Decline</span>
                                        <?php elseif($data->order_status ==9): ?><span class="textSize badge badge-secondary">Active</span>
                                        <?php elseif($data->order_status ==10): ?><span class="textSize badge badge-secondary">Completed</span>
                                        <?php elseif($data->order_status ==11): ?><span class="textSize badge badge-danger">Canceled</span>
                                        <?php else: ?><span class="badge">N/A</span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <input id="exp<?php echo e($key+1); ?>" class="exp"  type="checkbox">
                                        <div class="text">
                                            <label class="btns" for="exp<?php echo e($key+1); ?>"></label>
                                            <?php echo e($data->comment); ?>

                                        </div>
                                    </td>

                                    <td><?php if($data->file != null): ?><a href="<?php echo e(asset('upload/orderFile/'.$data->file)); ?>" download><?php echo e($data->file); ?></a><?php else: ?> No File <?php endif; ?></td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">

                                                <?php if((Auth::user()->role == 1 || Auth::user()->role == 2) &&($data->order_status == 2 || $data->order_status ==3 ||$data->order_status ==9) &&  $data->available_quantity > 0): ?>
                                                    <a class="dropdown-item"  data-toggle="modal" data-target="#modal-default"
                                                    onclick="getOrderId(<?php echo e($data->id); ?>)" ><i
                                                        class="fas fa-check" style="padding-right:10px;"></i> Assign</a>
                                                <?php endif; ?>

                                                <?php if($data->file == null): ?>
                                                    <a class="dropdown-item"  data-toggle="modal" data-target="#modal-fileAdd"
                                                    onclick="getOrderId2(<?php echo e($data->id); ?>)" ><i
                                                        class="fas fa-check" style="padding-right:10px;"></i>Add Text/file</a>

                                                    <a class="dropdown-item"  data-toggle="modal" data-target="#modal-assignforadd"
                                                        onclick="getOrderId2(<?php echo e($data->id); ?>)" ><i
                                                            class="fas fa-check" style="padding-right:10px;"></i>Assign For TextAdd</a>
                                                <?php else: ?>
                                                   <a class="dropdown-item"  data-toggle="modal" data-target="#modal-fileEdit"
                                                      onclick="editFile(<?php echo e($data->id); ?>)" ><i
                                                    class="fas fa-edit" style="padding-right:10px;"></i>Edit Text/file</a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>


<div class="modal fade" id="modal-default">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Assign Order</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="assignOrder" action="<?php echo e(url('assign-order')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" id="id">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Select Vendor/Employee<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="ven_Emp_id" id="ven_Emp_id" onchange="getType(this);" required="" class="form-control select2bs4">
                                                        <option value="" selected="" disabled="">Select Vendor/Employee
                                                        </option>
                                                        <?php $__currentLoopData = $workers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($item->id); ?>">
                                                            <?php echo e($item->name); ?> ~~ <?php echo e($item->email); ?> ~~
                                                            <?php if($item->role == 6): ?>
                                                                Employee
                                                            <?php elseif($item->role == 5): ?>
                                                                Supervisor
                                                            <?php elseif($item->role == 4): ?>
                                                                Vendor
                                                            <?php else: ?>
                                                                Admin
                                                            <?php endif; ?>
                                                        </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Dalivary Date <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" id="date_picker" name="target_date" required class="form-control">
                                                    <span id='message3'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Quantity <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number"  name="total_quantity" id="total_quantity" class="form-control" required="">
                                                    <span id='message'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Service Cost(/Work) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" step="0.0001" name="service_cost" id="service_cost" class="form-control" required="">
                                                    <span id='message2'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Budget <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_budget" id="total_budget" class="form-control" readonly required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6" id="start_point_div">
                                            <div class="form-group">
                                                <h5>Start Point </h5>
                                                <div class="controls">
                                                    <input type="number" id="start_point" name="start_point" class="form-control">
                                                    <span id='message3'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<div class="modal fade" id="modal-fileAdd">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add File</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="assignOrder" action="<?php echo e(url('upload-order-text')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" id="id2">
                            <div class="row">
                                <div class="col-12">

                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Upload File<span class="text-danger">*</span></h5>
                                                <input type="file" name="file" class="form-control" required="">
                                            </div>
                                        </div> <!-- End Col md 6 -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<div class="modal fade" id="modal-assignforadd">
    <div class="modal-dialog ">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Assign For Add Text</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="assignOrder" action="<?php echo e(url('assign-order-for-text-add')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" id="id3">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Select Vendor/Employee<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="ven_Emp_id" id="ven_Emp_id" onchange="getType(this);" required="" class="form-control select2bs4">
                                                        <option value="" selected="" disabled="">Select Employee
                                                        </option>
                                                        <?php $__currentLoopData = $assign; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                          <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?> ~~ <?php echo e($item->email); ?> ~~ <?php if($item->role == 6): ?> Employee <?php elseif($item->role == 5): ?> Supervisor <?php endif; ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<div class="modal fade" id="modal-fileEdit">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit File</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="assignOrder" action="<?php echo e(url('upload-order-text')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" id="id33">
                            <div class="row">
                                <div class="col-12">

                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Upload File<span class="text-danger">*</span></h5>
                                                <input type="file" name="file" class="form-control" required="">

                                                <div class="row" id="extra">
                                                    <div class="col-md-10">
                                                        <input type="text" id="file12" class="form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <a href="javascript:void(0)" onclick="deleteFile()" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<script type="text/javascript">

    $("#calculation").on("keyup click", function() {
        var qty = parseFloat($('#total_quantity').val());
        var price = parseFloat($('#service_cost').val());

        var unit_total = parseFloat(qty * price);

        $("#total_budget").val(unit_total.toFixed(4));
    });

    $('.assignOrder').submit(function(){
        $(this).find(':submit').attr( 'disabled','disabled' );
        setTimeout(() => {
            $(this).find(':submit').attr( 'disabled',false );
        }, 2000)
    });
</script>

<script>
    function getType(r) {
        var id = (r.value);
        console.log(id);

        if(id != ''){
            $.ajax({
                url:"findUserTypeToAssign",
                method:"GET",
                data: {
                    id: id,
                },
                dataType:"JSON",
                 success:function (data) {
                    console.log(data);
                    if(data.role != 4)
                    {
                       $( "#service_cost" ).prop( "readonly", true );
                       $( "#service_cost" ).val(0.0);
                       $( "#total_budget" ).val(0.0);
                    }
                    else{
                        $( "#service_cost" ).prop( "readonly", false );
                    }
                }

            });
        }

    }
</script>

<script>
    function getOrderId(r)
    {
       console.log(r);
       $("#id").val(r);
       var id = r;

       if (id != '') {
            $.ajax({
                url: "findOrderDetailsData",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data)
                {
                    console.log(data);
                    $("#total_quantity").attr({
                    "max" : data.available_quantity,
                    "min" : 1
                    });
                    $('#message').html('Available Work Here - '+data.available_quantity).css('color', 'red');
                    $('#message2').html('Client Rate - '+data.service_cost).css('color', 'red');
                    $('#message3').html('Client Targeted Date - '+data.target_date).css('color', 'red');

                    // if(data.service_type_id != 1 && data.service_type_id != 2)
                    // {
                    //     $("#start_point_div").addClass('d-none');
                    // }else{
                    //     $("#start_point_div").removeClass('d-none');
                    // }
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
    function getOrderId2(r)
    {
       console.log(r);
       $("#id2").val(r);
       $("#id3").val(r);
    }
</script>

<script>
function editFile(r)
{
   console.log(r);
   var id =r;
   $("#id33").val(id);
   //console.log(id);

   if (id != '') {
            $.ajax({
                url: "getValueFromOrder",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data) {
                    console.log(data);
                    $("#file12").val(data.file);
                    $("#id3").val(data.id);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
}

function deleteFile()
    {
       var id = $("#id3").val();
       console.log(id);

       if (id != '') {
            $.ajax({
                url: "deleteFileFromOrder",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data)
                {
                    console.log(data);
                    var div = document.getElementById('extra');
                    if (div.style.display !== 'none') {
                        div.style.display = 'none';
                    }
                    else {
                        div.style.display = 'block';
                    }
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>
<?php $__env->stopSection(); ?>


<?php else: ?>
    <?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/manageOrder/viewOrders.blade.php ENDPATH**/ ?>