<?php

use Illuminate\Support\Carbon;

$currentDate = Carbon::now();
$date = strtotime($currentDate);
$today = date('Y-m-d', $date);
// echo $today;  strtotime(date('Y-m-d', $currentDate));
?>

<?php if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 ): ?>


<?php $__env->startSection('title'); ?>
Work
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section class="content">
    <div class="container-fluid">

        <div class="row" style="margin-top:10px;">

            <div class="col-md-12">
                <div class="card bg-gradient-success">
                    <div class="card-header border-0 ui-sortable-handle" style="cursor: move;">
                        <h3 class="card-title">
                            Order Details
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-success btn-sm" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="card-body pt-0" style="display: block;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Assign Order ID : <b><?php echo e($assign->unique_id); ?></b>
                                        </h2>
                                        <input type="hidden" name="assign_order_id" id="assign_order_id" value="<?php echo e($assign->id); ?>">
                                    </div>

                                    <div class="card-body">
                                        <div class="row">
                                            <h2 class="card-title text-dark">App Link: </h2>
                                            <div class="col-md-5">
                                                <a href="<?php echo e($Orders->apps_link); ?>" target="_blank">Click Me</a>
                                            </div>
                                            <h2 class="card-title text-dark">File: </h2>
                                            <div class="col-md-5">
                                                <a href="<?php echo e(asset('upload/orderFile/'.$Orders->file)); ?>" download>Download
                                                    Me</a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-footer bg-light p-0" style="border-radius: 0.35rem;">
                                        <div class="row pb-3">
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Order Date
                                                            <span class="float-right ">
                                                                <b><?php echo e($assign->created_date); ?></b></span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Dalivary Date
                                                            <span class="float-right text-danger">
                                                                <b><?php echo e($assign->target_date); ?></b></span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Speed Per day
                                                            <span class="float-right">
                                                                <b><?php echo e($Orders->perday); ?></b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            KeyWord
                                                            <span class="float-right">
                                                                <b> <?php echo e($Orders->key_word); ?> </b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>

                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Service Type
                                                            <span class="float-right">
                                                                <b><?php echo e($Orders->service->name); ?></b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Platfrom
                                                            <span class="float-right">
                                                                <b><?php echo e($Orders->platform); ?></b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            GEO
                                                            <span class="float-right">
                                                                <b><?php echo e($Orders->geo); ?></b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Start point
                                                            <span class="float-right">
                                                                <b><?php echo e($assign->start_point); ?></b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Work Status</h2>
                                    </div>

                                    <div class="card-body">
                                        <div class="row" id="changeStatus">
                                            <h2 class="card-title text-dark">Status: </h2>
                                            <div class="col-md-10">
                                                <div class="form-group">

                                                    <?php if($assign->work_status == 10 || $assign->work_status == 7): ?>
                                                    <select id="inputStatus" disabled class="form-control custom-select">

                                                        <?php else: ?>
                                                        <select id="inputStatus" onchange="assignStatus(this)" class="form-control custom-select">
                                                            <?php endif; ?>

                                                            <option disabled="">Select one</option>
                                                            <option value="3" <?php echo e(($assign->work_status ==3)?'selected':''); ?>>Work
                                                                in Progress</option>
                                                            <option value="7" <?php echo e(($assign->work_status ==7)?'selected':''); ?>>On
                                                                Hold</option>
                                                            <option value="5" <?php echo e(($assign->work_status ==5)?'selected':''); ?>>
                                                                Refilling</option>
                                                            <option value="6" <?php echo e(($assign->work_status ==6)?'selected':''); ?>>
                                                                Refiled</option>
                                                            <option value="4" <?php echo e(($assign->work_status ==4)?'selected':''); ?>>
                                                                Finished</option>
                                                            <option value="10" disabled="disabled" <?php echo e(($assign->work_status ==10)?'selected':''); ?>>
                                                                Completed</option>
                                                            <option value="2" disabled="disabled" <?php echo e(($assign->work_status ==2)?'selected':''); ?>>
                                                                Accept</option>
                                                            <option value="1" disabled="disabled" <?php echo e(($assign->work_status == 1)?'selected':''); ?>>
                                                                Pending</option>
                                                            <option value="11" disabled="disabled" <?php echo e(($assign->work_status == 11)?'selected':''); ?>>
                                                                Canceled</option>
                                                        </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php
                                    $query = App\Models\WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $assign->id);

                                    $countAliveOkStatus = $query->where('work_details_status', 2)->count();
                                    $progressStatus = $countAliveOkStatus > 0 ? ($countAliveOkStatus / $assign->total_quantity) * 100 : 0;
                                    // $pStatus = ($total * 100) / $assign->total_quantity;

                                    $getTotal = App\Models\WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $assign->id)->where('posting_status', 1)->count();
                                    $postingStatus = $getTotal > 0 ? ($getTotal / $assign->total_quantity) * 100 : 0;
                                    ?>

                                    <div class="card-footer bg-light pb-3" style="border-radius: 0.35rem; margin-top: -28px;">
                                        <div class="col-md-12">
                                            <ul class="nav nav-pills flex-column">
                                                <li class="nav-item">
                                                    <a class="nav-link">Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar" aria-valuenow="<?php echo e($progressStatus); ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo e($progressStatus); ?>%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                <?php echo e(number_format($progressStatus)); ?>% Completed
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            <?php echo e($countAliveOkStatus); ?> / <?php echo e($assign->total_quantity); ?>

                                                        </h6>
                                                    </a>

                                                    <?php if($Orders->service_type_id == 1 || $Orders->service_type_id == 2): ?>
                                                    <a class="nav-link">Posting Status Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar" aria-valuenow="<?php echo e($postingStatus); ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo e($postingStatus); ?>%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                <?php echo e(number_format($postingStatus)); ?>% Complete
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            <?php echo e($getTotal); ?>/<?php echo e($assign->total_quantity); ?>

                                                        </h6>
                                                    </a>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->
                            </div>
                            <div class="col-md-3">
                                <div class="card pb-5">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Reason For Refilling</h2>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body pb-4">
                                        <div class="row">
                                            <?php if($Orders->reason != null && $Orders->order_status ==5): ?>
                                            <div class="col-md-12" style="overflow-y:scroll; height:146px; background:white">
                                                <h2 class="card-title text-dark"><?php echo e($Orders->reason); ?></h2>
                                            </div>
                                            <!-- /.col -->
                                            <?php else: ?>
                                            <div class="col-md-12" style="height:146px; background:white">

                                            </div>
                                            <?php endif; ?>

                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                </div>
                                <!-- /.card -->
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>



            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:10px;">
                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Works Details List
                            <?php if($assign->work_status != 10 && $assign->work_status != 7): ?>
                            <?php if($total_avail >= $assign->total_quantity): ?>
                            <a href="#" <?php if(true): echo 'disabled'; endif; ?> title="" id="complete" title="Already Completed The Work !!">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <?php else: ?>

                            <?php if( $Orders->service_type_id == 3): ?>
                            <a href="#" title="" data-toggle="modal" data-target="#modal-install">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <?php else: ?>

                            <a href="#" title="" data-toggle="modal" data-target="#modal-default">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <?php endif; ?>
                            <a href="#" title="" data-toggle="modal" data-target="#modal-default4">
                                <i class="fas fa-upload" title="Upload Exel File" style="float: right; font-size:28px; padding-right:10px;"></i>
                            </a>

                            <?php endif; ?>
                            <?php endif; ?>
                            <a href="<?php echo e(route('inProgress-order-v')); ?>">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <?php if( $Orders->service_type_id !=3): ?>
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Work U_Id</th>
                                    <th width="25%">Review Text</th>
                                    <th>Title</th>
                                    <th>User Name</th>
                                    <th>Rating</th>
                                    <th>Posting status</th>
                                    <th>Live Date</th>
                                    <th>Status</th>
                                    <?php if($assign->ven_Emp_id == $authUser->id): ?>
                                    <th> Action </th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <input type="hidden" id="workId2[]" value="<?php echo e($data->id); ?>">
                                    <td><?php echo e($key+1); ?></td>
                                    <td><a href="#"><?php echo e($data->work_details_u_id); ?></a></td>
                                    <td><?php echo e($data->reiew_discription); ?></td>
                                    <td><?php echo e($data->title); ?></td>
                                    <td>
                                        <?php if($data->user_name != null): ?><input type="text" class="form-control" id="userNameInput1" value="<?php echo e($data->user_name); ?>" readonly="true" ondblclick="this.readOnly='';">
                                        <p hidden><?php echo e($data->user_name); ?></p>
                                        <?php else: ?>
                                        <input type="text" id="userNameInput" class="form-control" value="N/A" readonly="true" ondblclick="this.readOnly='';">
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php for($i=0;$i<$data->ratting;$i++): ?>
                                            <i class="fa fa-star text-warning"></i>
                                            <?php endfor; ?>
                                            <?php for($i=0;$i<5-$data->ratting;$i++): ?>
                                                <i class="far fa-star text-gray"></i>
                                                <?php endfor; ?>
                                                <p hidden><?php echo e($data->ratting); ?></p>
                                    </td>
                                    <!-- <td><a href="<?php echo e($data->link); ?>" target="_blank">Click Me</a></td> -->

                                    <!-- Posting Status  -->
                                    <td>
                                        <div id="<?php echo e('viewPostingStatus'.$data->id); ?>" ondblclick="getOpenPostingStatus(<?php echo e($data->id); ?>)" title="Double Click For Update">
                                            <?php if($data->posting_status == 1): ?><span class="textSize badge badge-success">
                                                Posted </span>

                                            <?php elseif($data->posting_status ==2): ?><span class="textSize badge badge-danger">Missed</span>

                                            <?php else: ?><span class="badge">N/A</span>
                                            <?php endif; ?>
                                        </div>
                                        <div id="<?php echo e('updatePostingStatus'.$data->id); ?>" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                <?php if($Orders->order_status == 10 || $Orders->order_status == 7): ?>
                                                <select disabled class="form-control custom-select">
                                                    <?php else: ?>
                                                    <select id="workStatus" onchange="postingStatus(this)" class="form-control custom-select">
                                                        <?php endif; ?>
                                                        <option value="" disabled selected>Select One</option>
                                                        <option value="1" <?php echo e(($data->posting_status ==1)?'selected':''); ?>>
                                                            <span class="textSize badge badge-success">Posted</span>
                                                        </option>
                                                        <option value="2" <?php echo e(($data->posting_status ==2)?'selected':''); ?>>
                                                            <span class="textSize badge badge-info"> Missed </span>
                                                        </option>

                                                        <input type="hidden" id="workId" value="<?php echo e($data->id); ?>">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    <!-- End Posting Status  -->
                                    <td class="state1">
                                        <?php if($data->created_date !=null): ?>
                                        <input type="text" class="form-control" id="<?php echo e("cuurent-date".$data->id); ?>" ondblclick="hide(<?php echo e($data->id); ?>)" readonly="true" value="<?php echo e(date('m/d/Y', strtotime($data->created_date))); ?>" max=<?php echo e($today); ?>>
                                        <p hidden><?php echo e($data->created_date); ?></p>
                                        <input type="hidden" id="<?php echo e("input-date".$data->id); ?>" class="form-control" onchange="changeDate(this)" name="date" max=<?php echo e($today); ?>>
                                        <?php else: ?>
                                        <input type="date" class="form-control" onchange="changeDate(this)" name="date" max=<?php echo e($today); ?>>
                                        <?php endif; ?> <input type="hidden" id="workId" value="<?php echo e($data->id); ?>">
                                    </td>

                                    <td class="state">
                                        <div id="<?php echo e('viewStatus'.$data->id); ?>" ondblclick="getOpen(<?php echo e($data->id); ?>)" title="Double Click For Update">
                                            <?php if($data->work_details_status ==1): ?><span class="textSize badge badge-info">Alive</span>
                                            <?php elseif($data->work_details_status ==2): ?><span class="textSize badge badge-success">Alive Ok</span>
                                            <?php elseif($data->work_details_status ==3): ?><span class="textSize badge badge-danger">Duplicate</span>
                                            <?php elseif($data->work_details_status ==4): ?><span class="textSize badge badge-warning ">Dropped</span>
                                            <?php elseif($data->work_details_status ==5): ?><span class="textSize badge badge-danger">Wrong Text</span>
                                            <?php else: ?><span class="badge">N/A</span>
                                            <?php endif; ?>
                                        </div>
                                        <div id="<?php echo e('updateStatus'.$data->id); ?>" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                <?php if($Orders->order_status == 10 || $Orders->order_status == 7): ?>
                                                <select disabled class="form-control custom-select">
                                                    <?php else: ?>
                                                    <select id="workStatus" onchange="checkbox(this)" class="form-control custom-select">
                                                        <?php endif; ?>

                                                        <option value="2" <?php echo e(($data->work_details_status ==2)?'selected':''); ?>>
                                                            <span class="textSize badge badge-success">Alive Ok</span>
                                                        </option>
                                                        <option value="1" <?php echo e(($data->work_details_status ==1)?'selected':''); ?>>
                                                            <span class="textSize badge badge-info">Alive</span>
                                                        </option>

                                                        <option value="3" <?php echo e(($data->work_details_status ==3)?'selected':''); ?>>
                                                            <span class="textSize badge badge-danger">Duplicate</span>
                                                        </option>
                                                        <option value="4" <?php echo e(($data->work_details_status ==4)?'selected':''); ?>>
                                                            <span class="textSize badge badge-warning">Dropped</span>
                                                        </option>
                                                        <option value="5" <?php echo e(($data->work_details_status ==5)?'selected':''); ?>>
                                                            <span class="textSize badge badge-danger">Wrong Text</span>
                                                        </option>
                                                        <input type="hidden" id="workId" value="<?php echo e($data->id); ?>">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    <?php if($assign->ven_Emp_id == $authUser->id): ?>
                                    <td class="py-0 align-middle text-center">
                                        <?php if($data->work_details_status ==2 || ($assign->work_status == 10 || $assign->work_status == 7 )): ?>
                                        <div class="btn-group btn-group-sm">
                                            <a href="javascript:void(0)" id="warning" class="btn btn-info"><i class="fas fa-edit"></i> </a>
                                            <a href="javascript:void(0)" id="warning" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                        </div>
                                        <?php else: ?>
                                        <div class="btn-group btn-group-sm" disabled>

                                            <a class="btn btn-info" data-toggle="modal" data-target="#modal-default2" onclick="getValue(<?php echo e($data->id); ?>)"><i class="fas fa-edit"></i></a>

                                            <a href="<?php echo e(url('delete-work-details-'.$data->id)); ?>" id="delete" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                        </div>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php else: ?>
                        <div class="btn-group " style="float: right; padding-right:10px;">

                            <?php if($Orders->order_status == 10 || $Orders->order_status == 7): ?>
                            <select disabled class="form-control custom-select">
                                <?php else: ?>
                                <select id="workStatus" onchange="changeAllStatus(this)" class="form-control custom-select">
                                    <?php endif; ?>
                                    <option value="" disabled selected>
                                        <span class="textSize badge badge-success">Update Selected</span>
                                    </option>
                                    <option value="2">
                                        <span class="textSize badge badge-success">Alive Ok</span>
                                    </option>
                                    <option value="1">
                                        <span class="textSize badge badge-info">Alive</span>
                                    </option>

                                    <option value="3">
                                        <span class="textSize badge badge-danger">Duplicate</span>
                                    </option>
                                    <option value="4">
                                        <span class="textSize badge badge-warning">Dropped</span>
                                    </option>
                                    <option value="5">
                                        <span class="textSize badge badge-danger">Wrong Text</span>
                                    </option>

                                </select>
                        </div>

                        <table id="example1" class="table dataTable table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center" width="8%"><input class="form-check-input" id="check_all" type="checkbox">SN</th>
                                    <th>Work U_Id</th>
                                    <th>Install Date</th>
                                    <th>Keyword</th>
                                    <th>Country</th>
                                    <th>Country Code</th>
                                    <th>osVersion</th>
                                    <th>IDFA</th>
                                    <th>IP</th>
                                    <th>Status</th>
                                    <?php if($assign->ven_Emp_id == $authUser->id): ?><th>Action</th><?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <input class="form-check-input td_checkbox" id="<?php echo e('td_checkbox_'.$data->id); ?>" name="check_id[]" type="checkbox" data-id=<?php echo e($data->id); ?>>
                                        <?php echo e($key+1); ?>

                                    </td>
                                    <td><a href="#" target="_blank"><?php echo e($data->work_details_u_id); ?></a></td>
                                    <td><?php echo e(date('m/d/Y', strtotime($data->install_date))); ?></td>
                                    <td><?php echo e($data->keyword); ?></td>
                                    <td><?php echo e($data->country); ?></td>
                                    <td><?php echo e($data->country_code); ?></td>
                                    <td><?php echo e($data->os_version); ?></td>
                                    <td><input type="hidden" id="<?php echo e('idfa_'.$data->id); ?>" value="<?php echo e($data->idfa); ?>"><?php echo e($data->idfa); ?></td>
                                    <td><?php echo e($data->ip); ?></td>
                                    <td class="state">
                                        <div id="<?php echo e('viewStatus'.$data->id); ?>" ondblclick="getOpen(<?php echo e($data->id); ?>)" title="Double Click For Update">
                                            <?php if($data->work_details_status ==1): ?><span class="textSize badge badge-info">Alive</span>
                                            <?php elseif($data->work_details_status ==2): ?><span class="textSize badge badge-success">Alive Ok</span>
                                            <?php elseif($data->work_details_status ==3): ?><span class="textSize badge badge-danger">Duplicate</span>
                                            <?php elseif($data->work_details_status ==4): ?><span class="textSize badge badge-warning ">Dropped</span>
                                            <?php elseif($data->work_details_status ==5): ?><span class="textSize badge badge-danger">Wrong Text</span>
                                            <?php else: ?><span class="badge">N/A</span>
                                            <?php endif; ?>
                                        </div>
                                        <div id="<?php echo e('updateStatus'.$data->id); ?>" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                <?php if($Orders->order_status == 10 || $Orders->order_status == 7): ?>
                                                <select disabled class="form-control custom-select">
                                                    <?php else: ?>
                                                    <select id="workStatus" onchange="checkbox(this)" class="form-control custom-select">
                                                        <?php endif; ?>
                                                        <option value="2" <?php echo e(($data->work_details_status ==2)?'selected':''); ?>>
                                                            <span class="textSize badge badge-success">Alive Ok</span>
                                                        </option>
                                                        <option value="1" <?php echo e(($data->work_details_status ==1)?'selected':''); ?>>
                                                            <span class="textSize badge badge-info">Alive</span>
                                                        </option>

                                                        <option value="3" <?php echo e(($data->work_details_status ==3)?'selected':''); ?>>
                                                            <span class="textSize badge badge-danger">Duplicate</span>
                                                        </option>
                                                        <option value="4" <?php echo e(($data->work_details_status ==4)?'selected':''); ?>>
                                                            <span class="textSize badge badge-warning">Dropped</span>
                                                        </option>
                                                        <option value="5" <?php echo e(($data->work_details_status ==5)?'selected':''); ?>>
                                                            <span class="textSize badge badge-danger">Wrong Text</span>
                                                        </option>
                                                        <input type="hidden" id="workId" value="<?php echo e($data->id); ?>">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    <?php if($assign->ven_Emp_id == $authUser->id): ?>
                                    <td class="py-0 align-middle text-center">
                                        <?php if($data->work_details_status ==2): ?>
                                        <div class="btn-group btn-group-sm">
                                            <a href="javascript:void(0)" id="warning" class="btn btn-info"><i class="fas fa-edit"></i> </a>
                                            <a href="javascript:void(0)" id="warning" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                        </div>
                                        <?php else: ?>
                                        <div class="btn-group btn-group-sm" disabled>

                                            <a class="btn btn-info" data-toggle="modal" data-target="#modal-default3" onclick="getValue(<?php echo e($data->id); ?>)"><i class="fas fa-edit"></i></a>

                                            <a href="<?php echo e(url('delete-work-details-'.$data->id)); ?>" id="delete" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                        </div>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php endif; ?>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>

</section>


<!-------add work without Install------------->
<div class="modal fade" id="modal-default">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="newOrderAdd" action="<?php echo e(url('store-work-details-v')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vandor_id" id="vandor_id" value="<?php echo e($assign->ven_Emp_id); ?>">
                            <input type="hidden" name="order_id" id="order_id" value="<?php echo e($assign->order_id); ?>">
                            <input type="hidden" name="assign_id" id="assign_id" value="<?php echo e($assign->id); ?>">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Review Text<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <textarea type="number" name="reiew_discription" id="reiew_discription" class="form-control" required=""></textarea>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Rating <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" min="1" max="5" name="ratting" id="ratting" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Work Title <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" step="title" name="title" id="title" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>User Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="user_name" id="user_name" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Posting Status <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="posting_status" class="form-control custom-select">
                                                        <option value="" disabled selected>Select One</option>
                                                        <option value="1">
                                                            <span class="textSize badge badge-success">Posted</span>
                                                        </option>
                                                        <option value="2">
                                                            <span class="textSize badge badge-info"> Missed </span>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!--------------add work Install------------->
<div class="modal fade" id="modal-install">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" class="newOrderAdd" action="<?php echo e(url('store-work-details-install-v')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vandor_id" id="vandor_id2" value="<?php echo e($assign->ven_Emp_id); ?>">
                            <input type="hidden" name="order_id" id="order_id2" value="<?php echo e($assign->order_id); ?>">
                            <input type="hidden" name="assign_id" id="assign_id2" value="<?php echo e($assign->id); ?>">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Install date (UTC) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" name="date" id="date5" class="form-control" required="" max="<?php echo e($today); ?>">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Keyword<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="keyword" id="keyword" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>osVersion <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="os" id="os" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country <span class="text-danger">*</span></h5>
                                                <select class="col-md-12 form-control select2bs4" id="country" name="country">
                                                    <option id="clientName" selected="">Select Clients</option>

                                                </select>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country Code <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="c_code" id="c_code" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>IP <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="ip" id="ip" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>IDFA <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="idfa" id="idfa" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!--------------Edit work Install------------->
<div class="modal fade" id="modal-default2">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="<?php echo e(url('update-work-details-v')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vandor_id" id="vandor_id1">
                            <input type="hidden" name="order_id" id="order_id1">
                            <input type="hidden" name="assign_id" id="assign_id1">
                            <input type="hidden" name="work_id" id="work_id1">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Review Text<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <textarea type="number" name="reiew_discription" id="reiew_discription1" class="form-control" required=""></textarea>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Ratting <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" min="1" max="5" name="ratting" id="ratting1" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Work Title <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" step="title" name="title" id="title1" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>User Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="user_name" id="user_name1" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Posting Status <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select id="posting_status1" name="posting_status" class="form-control custom-select">
                                                        <option value="" disabled selected>Select One</option>
                                                        <option value="1">
                                                            <span class="textSize badge badge-success">Posted</span>
                                                        </option>
                                                        <option value="2">
                                                            <span class="textSize badge badge-info"> Missed </span>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                </div> <!-- End 3rd Row -->

                                <div class="row" style="margin-top: 20px">
                                    <!-- 7TH Row -->
                                    <div class="col-md-5">
                                        <div class="text-xs-right">
                                            <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                        </div>
                                    </div>
                                </div> <!-- End 7TH Row -->
                            </div>
                    </div>
                    </form>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!--------------Edit work Install------------->
<div class="modal fade" id="modal-default3">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Work</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="<?php echo e(url('update-work-details-v')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vandor_id" id="vandor_id5">
                            <input type="hidden" name="order_id" id="order_id5">
                            <input type="hidden" name="assign_id" id="assign_id5">
                            <input type="hidden" name="work_id" id="work_id5">

                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Install date (UTC) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="date" name="date" id="date5" class="form-control" required="" max="<?php echo e($today); ?>">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Keyword<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="keyword" id="keyword5" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>osVersion <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="os" id="os5" class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="country" id="country5" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Country Code <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="c_code" id="c_code5" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>IP <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="ip" id="ip5" class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>IDFA <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="idfa" id="idfa5" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>
                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                            <!------End Row---------->
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-------Upload File------------->
<div class="modal fade" id="modal-default4">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Upload File</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="<?php echo e(url('file-import')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vandor_id" id="vandor_id" value="<?php echo e($assign->ven_Emp_id); ?>">
                            <input type="hidden" name="order_id" id="order_id" value="<?php echo e($assign->order_id); ?>">
                            <input type="hidden" name="assign_id" id="assign_id" value="<?php echo e($assign->id); ?>">
                            <input type="hidden" name="service_type_id" id="service_type_id" value="<?php echo e($Orders->service_type_id); ?>">


                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Add File<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="file" name="file" id="file" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script>
    function hide(r) {
        document.getElementById("cuurent-date" + r).type = "hidden";
        document.getElementById("input-date" + r).type = "date";
    }

    $('.newOrderAdd').submit(function() {
        $(this).find(':submit').attr('disabled', 'disabled');
        //the rest of your code
        setTimeout(() => {
            $(this).find(':submit').attr('disabled', false);
        }, 2000)
    });
</script>


<script type="text/javascript">
    let allCheckVal = [];
    // Single check
    $('.td_checkbox').change(function() {
        getCheckRecords();
    });

    // All Check
    $("#check_all").change(function() {
        if ($(this).prop('checked')) {
            $('.td_checkbox').not(this).prop('checked', true);
        } else {
            $('.td_checkbox').not(this).prop('checked', false);
        }
        getCheckRecords();
    });

    //Get Check Records
    function getCheckRecords() {
        allCheckVal = [];
        $('.td_checkbox:checked').each(function() {
            allCheckVal.push($(this).attr('data-id'));
        });
    }

    function value(r) {
        var id = r;
    };

    function changeAllStatus(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var p_status = _this.value; // get the selected value

        if (allCheckVal.length > 0) {
            $.each(allCheckVal, function(key, id) {
                var idfa = $('#idfa_' + id).val();

                if (idfa == '' && p_status == 2) {
                    toastr.error("This Work Don't any IDFA number");
                } else {
                    updateWorkStatus(id, p_status);
                }
            });
        } else {
            Swal.fire({
                title: 'Are you sure Select Any thing?',
                text: "You don't Select Any Work !!",
                icon: 'warning',
                // showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'No, Close it!'
            })
        }
    }

    //update in sigle row
    function checkbox(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var p_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();
        updateWorkStatus(id, p_status);
    }

    //Update Request
    function updateWorkStatus(id, p_status) {
        if (id != '') {
            $.ajax({
                url: "updateWorkDetailsStatus",
                method: "GET",
                data: {
                    id: id,
                    p_status: p_status,
                },
                dataType: "JSON",
                success: function(data) {

                    toastr.success("Work status Update");

                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

<script type="text/javascript">
    function changeDate(_this) {
        var p_state = $(_this).closest('tr').find('#state1').text(); // get the text
        var p_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();

        if (id != '') {
            $.ajax({
                url: "updateWorkDetailsDate",
                method: "GET",
                data: {
                    id: id,
                    p_status: p_status,
                },
                dataType: "JSON",
                success: function(data) {

                    toastr.success(" Date Updated ");

                    // setTimeout(function () {
                    //     window.location.reload();
                    // }, 1000);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

<script>
    function assignStatus(r) {
        var value = r.value;
        var id = $('#assign_order_id').val();

        if (id != '') {
            $.ajax({
                url: "updateAssignWorStatus",
                method: "GET",
                data: {
                    id: id,
                    value: value,
                },
                dataType: "JSON",
                success: function(data) {
                    toastr.success(" Status Update ");

                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

<script>
    $('body').on('keypress', '#userNameInput', function(e) {
        if (e.which == 13) {
            //alert('enter');

            var parent = $(this).closest('tr');
            var id = parent.find('input:eq(0)').val();
            var value = parent.find('#userNameInput').val();

            //   var id =  $('#userNameInput').closest('td').find('#workId2').val();
            //   var value =  $('#userNameInput').val();

            if (id != '') {
                $.ajax({
                    url: "updateUserName",
                    method: "GET",
                    data: {
                        id: id,
                        value: value,
                    },
                    dataType: "JSON",
                    success: function(data) {
                        // window.location.reload();
                        toastr.success("User Name Update");
                    }
                })
            } else {
                alert("Something is wrong ..!!");
            }
        }
    });

    $('body').on('keypress', '#userNameInput1', function(e) {
        if (e.which == 13) {
            //alert('enter');

            var parent = $(this).closest('tr');
            var id = parent.find('input:eq(0)').val();
            var value = parent.find('#userNameInput1').val();

            //   var id =  $('#userNameInput').closest('td').find('#workId2').val();
            //   var value =  $('#userNameInput').val();

            if (id != '') {
                $.ajax({
                    url: "updateUserName",
                    method: "GET",
                    data: {
                        id: id,
                        value: value,
                    },
                    dataType: "JSON",
                    success: function(data) {
                        // window.location.reload();
                        toastr.success("User Name Update");

                    }
                })
            } else {
                alert("Something is wrong ..!!");
            }
        }
    });
</script>

<script>
    function getOpen(r) {
        $('#updateStatus' + r).removeAttr('hidden');
        $('#viewStatus' + r).attr('hidden', '');
    }
</script>

<!-- posting status Start-->
<script>
    function getOpenPostingStatus(r) {
        $('#updatePostingStatus' + r).removeAttr('hidden');
        $('#viewPostingStatus' + r).attr('hidden', '');
    }

    function postingStatus(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var posting_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();

        if (id != '') {
            $.ajax({
                url: "updatePostingStatus",
                method: "GET",
                data: {
                    id: id,
                    posting_status: posting_status,
                },
                dataType: "JSON",
                success: function(data) {
                    toastr.success(" Status Update ");

                    setTimeout(function() {
                        window.location.reload(true);
                    }, 1000);

                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

<script>
    function getValue(r) {
        $("#id").val(r);
        var id = r;
        if (id != '') {
            $.ajax({
                url: "editWork",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function(data) {

                    if (data.service_type_id == 3) {
                        $("#vandor_id5").val(data.vandor_id);
                        $("#order_id5").val(data.order_id);
                        $("#assign_id5").val(data.assign_id);
                        $("#work_id5").val(data.id);

                        $("#date5").val(data.install_date);
                        $("#keyword5").val(data.keyword);
                        $("#os5").val(data.os_version);
                        $("#country5").val(data.country);
                        $("#c_code5").val(data.country_code);
                        $("#ip5").val(data.ip);
                        $("#idfa5").val(data.idfa);
                    } else {
                        var total = parseInt(data.available) + parseInt(data.total_quantity);
                        $("#vandor_id1").val(data.vandor_id);
                        $("#order_id1").val(data.order_id);
                        $("#assign_id1").val(data.assign_id);
                        $("#work_id1").val(data.id);
                        $("#reiew_discription1").val(data.reiew_discription);
                        $("#ratting1").val(data.ratting);
                        $("#title1").val(data.title);
                        $("#posting_status1").val(data.posting_status);
                        $("#user_name1").val(data.user_name);
                    }

                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

<?php $__env->stopSection(); ?>

<?php else: ?>
<?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/manageOrder/checkWorksDetails/checkWorks.blade.php ENDPATH**/ ?>