<?php $__env->startSection('title'); ?>
Order Report
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="m-0 text-dark">Order Report</h5>
                    </div>

                    <form class="form-horizontal" method="post" action="<?php echo e(route('searchOrderReport')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>Select Date <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <input type="text" name="dates" class="form-control" value="" required=""
                                                placeholder="Select Date Range">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>Select Type <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <select name="type[]" required="" class="form-control multiSelect" multiple
                                                placeholder="Select Type">
                                                <option value="all" highlighted="">All</option>
                                                <option value="ios">iOS</option>
                                                <option value="android">Android</option>
                                                <option value="google">Google</option>
                                                <option value="others">Others</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>Select Client <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <select name="clients[]" required="" class="form-control multiSelect"
                                                multiple placeholder="Select Client">
                                                <option value="all" highlighted="">All</option>
                                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-3 mt-4">
                                    <button type="submit" class="btn btn-primary float-right">Search Report</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <?php if(count($orders) > 0): ?>
            <div class="col-md-12">
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="m-0 text-dark">Order Report Showing from <?php echo e($date_range); ?></h5>
                    </div>

                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Clients</th>
                                    <th>Unique Id</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Available Work</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $flag = 1;
                                ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td><a href="<?php echo e(url('client-profile-'.$data->order_creator_id)); ?>"
                                            target="_blank"><?php echo e($data?->client?->name); ?></a></td>
                                    <td><a href="<?php echo e(url('check-work-onOrder-'.$data->id)); ?>"
                                            target="_blank"><?php echo e($data->order_unique_id); ?></a></td>
                                    <td><a href="<?php echo e($data->apps_link); ?>" target="_blank">Link</a></td>
                                    <td><?php echo e($data->platform); ?></td>
                                    <td><?php echo e($data->geo); ?></td>
                                    <td><?php echo e($data->service->name); ?></td>
                                    <td><?php echo e($data->target_date); ?></td>
                                    <td><?php echo e($data->total_quantity); ?></td>
                                    <td><?php echo e($data->available_quantity); ?></td>
                                    <td><?php echo e($data->service_cost); ?></td>
                                    <td><?php echo e($data->total_budget); ?></td>
                                    <td><?php echo e($data->perday); ?></td>
                                    <td><?php echo e($data->key_word); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $total; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($tData->o_id == $data->id): ?>
                                        <?php echo e($tData->total); ?>/<?php echo e($data->total_quantity); ?>

                                        <?php
                                        $flag = 0;
                                        ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if( $flag == 1): ?>
                                        0/<?php echo e($data->total_quantity); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($data->order_status ==1): ?><span
                                            class="textSize badge badge-warning">Pending</span>
                                        <?php elseif($data->order_status ==2): ?><span
                                            class="textSize badge badge-info">Accept</span>
                                        <?php elseif($data->order_status ==3): ?><span class="textSize badge badge-success">In
                                            Work</span>
                                        <?php elseif($data->order_status ==4): ?><span
                                            class="textSize badge badge-warning ">Finished</span>
                                        <?php elseif($data->order_status ==5): ?><span
                                            class="textSize badge badge-danger">Refilling</span>
                                        <?php elseif($data->order_status ==6): ?><span
                                            class="textSize badge badge-secondary">Refiled</span>
                                        <?php elseif($data->order_status ==7): ?><span
                                            class="textSize badge badge-primary">Hold</span>
                                        <?php elseif($data->order_status ==8): ?><span
                                            class="textSize badge badge-danger">Decline</span>
                                        <?php elseif($data->order_status ==9): ?><span
                                            class="textSize badge badge-secondary">Active</span>
                                        <?php elseif($data->order_status ==10): ?><span
                                            class="textSize badge badge-secondary">Completed</span>
                                        <?php elseif($data->order_status ==11): ?><span
                                            class="textSize badge badge-danger">Canceled</span>
                                        <?php else: ?><span class="badge">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
            <?php endif; ?>

        </div>
</section>


<script>
$(function() {
    $('select').each(function() {
        var $select = $(this);

        $select.select2({
            theme: 'bootstrap4',
            width: 'style',
            placeholder: $select.attr('placeholder'),
            allowClear: Boolean($select.data('allow-clear')),
        });

        // Handle "All" option selection
        $select.on('select2:select', function(e) {
            if (e.params.data.id === 'all') {
                $select.find('option:not([value="all"])').prop('selected', true);
                $select.trigger('change');
            } else {
                // Deselect "All" if any other option is deselected
                $select.find('option[value="all"]').prop('selected', false);
                $select.trigger('change');
            }
        });

        // Handle any option deselection
        $select.on('select2:unselect', function(e) {
            // Deselect "All" if any option is deselected
            $select.find('option[value="all"]').prop('selected', false);
            $select.trigger('change');
        });

        // Update placeholder when no option is selected
        $select.on('change', function() {
            var selectedOptions = $(this).val();
            if (!selectedOptions || selectedOptions.length === 0) {
                $(this).siblings('.select2-container').find('.select2-selection__placeholder')
                    .text($(this).attr('placeholder'));
            }
        });
    });
});
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/advanceAnalytics/orderReport.blade.php ENDPATH**/ ?>