<?php if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 ): ?>


<?php $__env->startSection('title'); ?>
Pending Order List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Pending Order List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Unique Id</th>
                                    <th>Client Name</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Comment</th>
                                    <th>File</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td><?php echo e($data->order_unique_id); ?></td>
                                    <td><?php echo e($data->client->name); ?></td>
                                    <td><a href="<?php echo e($data->apps_link); ?>" target="_blank" >Link</a></td>
                                    <td><?php echo e($data->platform); ?></td>
                                    <td><?php echo e($data->geo); ?></td>
                                    <td><?php echo e($data->service->name); ?></td>
                                    <td><?php echo e($data->target_date); ?></td>
                                    <td><?php echo e($data->total_quantity); ?></td>
                                    <td><?php echo e($data->service_cost); ?></td>
                                    <td><?php echo e($data->total_budget); ?></td>
                                    <td><?php echo e($data->perday); ?></td>
                                    <td><?php echo e($data->key_word); ?></td>

                                    <td>
                                        <input id="exp<?php echo e($key+1); ?>" class="exp"  type="checkbox">
                                        <div class="text">
                                            <label class="btns" for="exp<?php echo e($key+1); ?>"></label>
                                            <?php echo e($data->comment); ?>

                                        </div>
                                    </td>

                                    <td><?php if($data->file != null): ?><a href="<?php echo e(asset('upload/orderFile/'.$data->file)); ?>" download><?php echo e($data->file); ?></a><?php else: ?> No File <?php endif; ?></td>
                                    <td>

                                        <?php if($data->order_status ==1): ?><span class="textSize badge badge-warning">Pending <?php if($data->notify != null): ?><?php echo e($data->notify); ?><?php endif; ?></span>
                                        <?php elseif($data->order_status ==2): ?><span class="textSize badge badge-info">Accept</span>
                                        <?php elseif($data->order_status ==3): ?><span class="textSize badge badge-success">In Process</span>
                                        <?php elseif($data->order_status ==4): ?><span class="textSize badge badge-warning ">Finished</span>
                                        <?php elseif($data->order_status ==5): ?><span class="textSize badge badge-danger">Refilling</span>
                                        <?php elseif($data->order_status ==6): ?><span class="textSize badge badge-secondary">Refiled</span>
                                        <?php elseif($data->order_status ==7): ?><span class="textSize badge badge-primary">Hold</span>
                                        <?php elseif($data->order_status ==8): ?><span class="textSize badge badge-warning">Decline</span>
                                        <?php elseif($data->order_status ==9): ?><span class="textSize badge badge-primary">Active</span>
                                        <?php elseif($data->order_status ==10): ?><span class="textSize badge badge-success">Complete</span>
                                        <?php elseif($data->order_status ==11): ?><span class="textSize badge badge-danger">Canceled</span>
                                        <?php else: ?><span class="badge">N/A</span>
                                        <?php endif; ?>

                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                                                <a class="dropdown-item" href="<?php echo e(url('accept-pending-order-'.$data->id)); ?>"><i
                                                    class="fas fa-check" style="padding-right:10px;"></i> Accept</a>
                                                <a class="dropdown-item" href="<?php echo e(url('dicline-pending-order-'.$data->id)); ?>"><i class="fas fa-times-circle"
                                                    style="padding-right:10px; "></i> Dicline</a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>


<?php else: ?>
    <?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/manageOrder/viewPandingOrder.blade.php ENDPATH**/ ?>